<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;

$db = new Database();
$conn = $db->getConnection();
$message = $_GET['message'] ?? '';
$message_type = $_GET['status'] ?? '';
$employees = [];

// Çalışan ekleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_employee') {
    $full_name = $_POST['full_name'] ?? '';
    $title = $_POST['title'] ?? '';
    $email = $_POST['email'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $hire_date = $_POST['hire_date'] ?? date('Y-m-d');

    try {
        $stmt = $conn->prepare("INSERT INTO personnel (full_name, title, email, phone, hire_date) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$full_name, $title, $email, $phone, $hire_date]);
        $message = 'Yeni çalışan başarıyla eklendi!';
        $message_type = 'success';
        header("Location: calisanlar.php?status=success&message=" . urlencode($message));
        exit;
    } catch (PDOException $e) {
        $message = 'Hata: Çalışan eklenirken bir sorun oluştu. ' . $e->getMessage();
        $message_type = 'error';
        header("Location: calisanlar.php?status=error&message=" . urlencode($message));
        exit;
    }
}

try {
    $stmt = $conn->prepare("SELECT id, full_name, title, email, phone, hire_date FROM personnel ORDER BY full_name ASC");
    $stmt->execute();
    $employees = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Hata: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hati App - Çalışanlar</title>
    <link rel="stylesheet" href="css/style.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="header-actions">
    <h2>Çalışanlar</h2>
</div>
<?php if ($message): ?>
    <p class="message" style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
        <?php echo htmlspecialchars($message); ?>
    </p>
<?php endif; ?>
<div class="detail-box">
    <h3 class="detail-box-title">Yeni Çalışan Ekle</h3>
    <form action="calisanlar.php" method="POST">
        <input type="hidden" name="action" value="add_employee">
        <div class="form-grid">
            <div class="form-group">
                <label for="full_name">Ad Soyad *</label>
                <input type="text" id="full_name" name="full_name" required>
            </div>
            <div class="form-group">
                <label for="title">Unvan</label>
                <input type="text" id="title" name="title">
            </div>
            <div class="form-group">
                <label for="email">E-posta *</label>
                <input type="email" id="email" name="email" required>
            </div>
            <div class="form-group">
                <label for="phone">Telefon *</label>
                <input type="text" id="phone" name="phone" required>
            </div>
            <div class="form-group">
                <label for="hire_date">İşe Giriş Tarihi *</label>
                <input type="date" id="hire_date" name="hire_date" value="<?php echo date('Y-m-d'); ?>" required>
            </div>
        </div>
        <div class="form-actions">
            <button type="submit">Çalışan Ekle</button>
        </div>
    </form>
</div>
<hr>
<h3>Mevcut Çalışanlar</h3>
<?php if (empty($employees)): ?>
    <p>Henüz kayıtlı bir çalışan bulunmamaktadır.</p>
<?php else: ?>
    <table>
        <thead>
            <tr>
                <th>Ad Soyad</th>
                <th>Ünvan</th>
                <th>E-posta</th>
                <th>Telefon</th>
                <th>İşe Giriş Tarihi</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($employees as $employee): ?>
            <tr>
                <td><?php echo htmlspecialchars($employee['full_name']); ?></td>
                <td><?php echo htmlspecialchars($employee['title'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($employee['email']); ?></td>
                <td><?php echo htmlspecialchars($employee['phone'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($employee['hire_date']); ?></td>
                <td>
                    <a href="edit_personnel.php?id=<?php echo $employee['id']; ?>">Düzenle</a> |
                    <a href="delete.php?table=personnel&id=<?php echo $employee['id']; ?>&redirect=calisanlar.php" onclick="return confirm('Bu çalışanı silmek istediğinizden emin misiniz?');">Sil</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>
</main>
</body>
</html>