<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$db = new Database();
$conn = $db->getConnection();
$evaluations = [];
$message = $_GET['message'] ?? '';
$message_type = $_GET['status'] ?? '';
try {
    $stmt_eval = $conn->prepare("SELECT ce.*, u.name AS evaluator_user_name, p.project_name FROM company_evaluations ce JOIN users u ON ce.evaluator_user_id = u.id LEFT JOIN projects p ON ce.project_id = p.id ORDER BY ce.evaluation_date DESC");
    $stmt_eval->execute();
    $evaluations = $stmt_eval->fetchAll(PDO::FETCH_ASSOC);
    $stmt_projects = $conn->prepare("SELECT id, project_name FROM projects ORDER BY project_name ASC");
    $stmt_projects->execute();
    $projects = $stmt_projects->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hati App - Firma Değerlendirmeleri</title>
    <link rel="stylesheet" href="css/style.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="header-actions">
    <h2>Firma Değerlendirmeleri</h2>
    <a href="create_company_evaluation.php">Yeni Değerlendirme Ekle</a>
</div>
<?php if ($message): ?>
    <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
        <?php echo htmlspecialchars($message); ?>
    </p>
<?php endif; ?>
<h3>Mevcut Değerlendirmeler</h3>
<?php if (empty($evaluations)): ?>
    <p>Henüz bir firma değerlendirmesi bulunmamaktadır.</p>
<?php else: ?>
    <table>
        <thead>
            <tr>
                <th>Firma Adı</th>
                <th>Değerlendiren</th>
                <th>Proje</th>
                <th>Puan</th>
                <th>Tarih</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($evaluations as $eval): ?>
            <tr>
                <td><?php echo htmlspecialchars($eval['company_name']); ?></td>
                <td><?php echo htmlspecialchars($eval['evaluator_user_name']); ?></td>
                <td><?php echo htmlspecialchars($eval['project_name'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($eval['rating']); ?>/5</td>
                <td><?php echo htmlspecialchars($eval['evaluation_date']); ?></td>
                <td>
                    <a href="view_company_evaluation.php?id=<?php echo $eval['id']; ?>">Gör</a> |
                    <a href="delete.php?table=company_evaluations&id=<?php echo $eval['id']; ?>&redirect=company_evaluations.php" onclick="return confirm('Bu kaydı silmek istediğinizden emin misiniz?');">Sil</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>
</main>
</body>
</html>