<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
use HatiApp\Core\Database;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $offer_id = $_POST['offer_id'] ?? 0;
    if ($offer_id > 0) {
        $db = new Database();
        $conn = $db->getConnection();
        try {
            $stmt = $conn->prepare("SELECT * FROM offers WHERE id = ? AND status = 'accepted'");
            $stmt->execute([$offer_id]);
            $offer = $stmt->fetch(PDO::FETCH_ASSOC);
            if (!$offer) {
                die('Hata: Dönüştürme işlemi için geçerli bir teklif bulunamadı.');
            }
            $stmt_items = $conn->prepare("SELECT SUM(total_price) AS grand_total FROM offer_items WHERE offer_id = ?");
            $stmt_items->execute([$offer_id]);
            $total_price = $stmt_items->fetch(PDO::FETCH_ASSOC)['grand_total'] ?? 0;
            $sale_no = 'SATIŞ-' . date('Y') . '-' . uniqid();
            $stmt_insert = $conn->prepare("INSERT INTO sales (sale_no, offer_id, customer_name, customer_email, sale_date, total_price) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt_insert->execute([
                $sale_no,
                $offer['id'],
                $offer['customer_name'],
                $offer['customer_email'],
                date('Y-m-d'),
                $total_price
            ]);
            $new_sale_id = $conn->lastInsertId();
            header("Location: view_sale.php?id=$new_sale_id");
            exit;
        } catch (PDOException $e) {
            die("Satışa dönüştürme işlemi sırasında bir hata oluştu: " . $e->getMessage());
        }
    } else {
        die('Hata: Geçerli bir teklif ID’si belirtilmedi.');
    }
}
?>