<?php
// Bu dosya, tüm fonksiyonları kendi içinde barındırır.
// Dosya yolu sorunlarını ortadan kaldırmak için tasarlanmıştır.

// Veritabanı bağlantı sınıfı
class Database {
    private $host = 'localhost';
    private $dbname = 'sarelsgf_erp';
    private $username = 'sarelsgf_erp'; 
    private $password = 'Qwer1907.'; 
    private $conn;

    public function __construct() {
        try {
            $this->conn = new PDO("mysql:host=$this->host;dbname=$this->dbname", $this->username, $this->password);
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            die("Veritabanı bağlantısı kurulamadı: " . $e->getMessage());
        }
    }

    public function getConnection() {
        return $this->conn;
    }
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    $role = 'admin';

    // Şifreyi güvenli bir şekilde şifreleme
    $hashed_password = password_hash($password, PASSWORD_BCRYPT);

    try {
        $db = new Database();
        $conn = $db->getConnection();
    } catch (PDOException $e) {
        die("Veritabanı bağlantısı kurulamadı: " . $e->getMessage());
    }

    try {
        // Kullanıcının veritabanında zaten var olup olmadığını kontrol et
        $stmt_check = $conn->prepare("SELECT COUNT(*) FROM users WHERE email = ?");
        $stmt_check->execute([$email]);
        if ($stmt_check->fetchColumn() > 0) {
            $message = "Bu e-posta adresi zaten kullanılıyor. Lütfen başka bir adres girin.";
        } else {
            // Yeni yöneticiyi ekle
            $stmt = $conn->prepare("INSERT INTO users (name, email, password, role) VALUES (?, ?, ?, ?)");
            $stmt->execute([$name, $email, $hashed_password, $role]);

            $message = "Yönetici kullanıcısı başarıyla oluşturuldu! Şimdi giriş yapabilirsiniz.";
        }
    } catch (PDOException $e) {
        $message = "Kullanıcı oluşturulurken bir hata oluştu: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Yönetici Oluştur</title>
</head>
<body>

<div>
    <h2>Yeni Yönetici Oluştur</h2>
    <?php if ($message): ?>
        <p style="color: green;"><?php echo $message; ?></p>
    <?php endif; ?>
    <form action="create_admin.php" method="POST">
        <div>
            <label for="name">Ad Soyad:</label>
            <input type="text" id="name" name="name" required>
        </div>
        <div>
            <label for="email">E-posta:</label>
            <input type="email" id="email" name="email" required>
        </div>
        <div>
            <label for="password">Şifre:</label>
            <input type="password" id="password" name="password" required>
        </div>
        <div>
            <button type="submit">Yönetici Oluştur</button>
        </div>
    </form>
</div>

</body>
</html>