<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;

$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db = new Database();
    $conn = $db->getConnection();

    $plate_number = $_POST['plate_number'] ?? '';
    $brand = $_POST['brand'] ?? '';
    $model = $_POST['model'] ?? '';
    $year = $_POST['year'] ?? null;
    $current_km = $_POST['current_km'] ?? 0;

    // Alanların boş olup olmadığını kontrol et
    if (empty($plate_number)) {
        $message = "Plaka numarası zorunludur.";
        $message_type = "error";
    } else {
        try {
            // Plaka numarasının benzersizliğini kontrol et
            $stmt_check = $conn->prepare("SELECT COUNT(*) FROM vehicles WHERE plate_number = ?");
            $stmt_check->execute([$plate_number]);
            if ($stmt_check->fetchColumn() > 0) {
                $message = "Bu plaka numarası zaten mevcut. Lütfen başka bir plaka numarası girin.";
                $message_type = "error";
            } else {
                $stmt = $conn->prepare("INSERT INTO vehicles (plate_number, brand, model, year, current_km) VALUES (?, ?, ?, ?, ?)");
                $stmt->execute([$plate_number, $brand, $model, $year, $current_km]);

                $message = "Araç başarıyla eklendi!";
                $message_type = "success";
                header("Location: araclar.php?status=success&message=" . urlencode($message));
                exit;
            }
        } catch (PDOException $e) {
            $message = "Hata: " . $e->getMessage();
            $message_type = "error";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hati App - Yeni Araç Ekle</title>
    <link rel="stylesheet" href="css/style.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="header-actions">
    <h2>Yeni Araç Ekle</h2>
    <a href="araclar.php" class="secondary-btn">Geri Dön</a>
</div>
<?php if ($message): ?>
    <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
        <?php echo htmlspecialchars($message); ?>
    </p>
<?php endif; ?>
<div class="detail-box">
    <form action="create_arac.php" method="POST">
        <div class="form-grid">
            <div class="form-group">
                <label for="plate_number">Plaka Numarası*:</label>
                <input type="text" id="plate_number" name="plate_number" required>
            </div>
            <div class="form-group">
                <label for="brand">Marka:</label>
                <input type="text" id="brand" name="brand">
            </div>
            <div class="form-group">
                <label for="model">Model:</label>
                <input type="text" id="model" name="model">
            </div>
            <div class="form-group">
                <label for="year">Yıl:</label>
                <input type="number" id="year" name="year" min="1900" max="<?php echo date('Y'); ?>">
            </div>
            <div class="form-group">
                <label for="current_km">Güncel KM:</label>
                <input type="number" id="current_km" name="current_km" min="0">
            </div>
        </div>
        <div class="form-actions">
            <button type="submit">Aracı Kaydet</button>
        </div>
    </form>
</div>
</body>
</html>