<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$message = $_GET['message'] ?? '';
$message_type = $_GET['status'] ?? '';
$db = new Database();
$conn = $db->getConnection();
$projects = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $company_name = $_POST['company_name'] ?? '';
    $project_id = $_POST['project_id'] ?? null;
    $rating = $_POST['rating'] ?? 1;
    $notes = $_POST['notes'] ?? '';
    $evaluation_date = date('Y-m-d');
    $evaluator_user_id = $_SESSION['user_id'];
    try {
        $stmt = $conn->prepare("INSERT INTO company_evaluations (company_name, project_id, evaluator_user_id, evaluation_date, rating, notes) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$company_name, $project_id, $evaluator_user_id, $evaluation_date, $rating, $notes]);
        $message = 'Firma değerlendirmesi başarıyla eklendi!';
        $message_type = 'success';
        header("Location: company_evaluations.php?status=success&message=" . urlencode($message));
        exit;
    } catch (PDOException $e) {
        $message = 'Hata: Değerlendirme eklenirken bir sorun oluştu. ' . $e->getMessage();
        $message_type = 'error';
    }
}
try {
    $stmt_projects = $conn->prepare("SELECT id, project_name FROM projects ORDER BY project_name ASC");
    $stmt_projects->execute();
    $projects = $stmt_projects->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Yeni Firma Değerlendirmesi</title>
    <link rel="stylesheet" href="css/style.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="header-actions">
    <h2>Yeni Firma Değerlendirmesi</h2>
    <a href="company_evaluations.php" class="secondary-btn">Geri Dön</a>
</div>
<?php if ($message): ?>
    <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
        <?php echo htmlspecialchars($message); ?>
    </p>
<?php endif; ?>
<div class="detail-box">
    <form action="create_company_evaluation.php" method="POST">
        <div class="form-grid">
            <div class="form-group">
                <label for="company_name">Firma Adı:</label>
                <input type="text" id="company_name" name="company_name" required>
            </div>
            <div class="form-group">
                <label for="project_id">İlgili Proje:</label>
                <select id="project_id" name="project_id">
                    <option value="">(Yok)</option>
                    <?php foreach ($projects as $project): ?>
                        <option value="<?php echo $project['id']; ?>"><?php echo htmlspecialchars($project['project_name']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <label for="rating">Puan (1-5):</label>
                <input type="number" id="rating" name="rating" min="1" max="5" value="5" required>
            </div>
        </div>
        <div class="form-group full-width">
            <label for="notes">Notlar:</label>
            <textarea id="notes" name="notes" rows="5"></textarea>
        </div>
        <div class="form-actions">
            <button type="submit">Değerlendirmeyi Kaydet</button>
        </div>
    </form>
</div>
</body>
</html>