<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// FPDF kütüphanesini dahil edin.
// Not: fpdf klasörü, public klasörünün içinde olmalıdır.
require_once __DIR__ . '/fpdf/fpdf.php';
require_once __DIR__ . '/../src/Core/Database.php';

use HatiApp\Core\Database;

$offer_id = $_GET['id'] ?? 0;
if ($offer_id == 0) {
    die("Geçersiz teklif ID.");
}

$db = new Database();
$conn = $db->getConnection();

try {
    // Teklif bilgilerini çekin
    $stmt_offer = $conn->prepare("SELECT * FROM offers WHERE id = ?");
    $stmt_offer->execute([$offer_id]);
    $offer = $stmt_offer->fetch(PDO::FETCH_ASSOC);

    if (!$offer) {
        die("Teklif bulunamadı.");
    }

    // Teklif kalemlerini çekin
    $stmt_items = $conn->prepare("SELECT * FROM offer_items WHERE offer_id = ? ORDER BY id ASC");
    $stmt_items->execute([$offer_id]);
    $offer_items = $stmt_items->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Veritabanı hatası: " . $e->getMessage());
}

// PDF sınıfını FPDF'den türeterek özelleştirin
class PDF extends FPDF {
    function Header() {
        // Logo
        $this->Image('img/logo.png', 10, 8, 33);
        $this->SetFont('Arial', 'B', 15);
        $this->Cell(80);
        $this->Cell(30, 10, 'Teklif Formu', 0, 0, 'C');
        $this->Ln(20);
    }
    
    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Sayfa ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
    }

    function OfferDetails($offer) {
        $this->SetFont('Arial', '', 12);
        $this->Cell(0, 10, 'Teklif No: ' . $offer['offer_no'], 0, 1);
        $this->Cell(0, 10, 'Musteri: ' . $offer['customer_name'], 0, 1);
        $this->Cell(0, 10, 'Telefon: ' . $offer['customer_phone'], 0, 1);
        $this->Cell(0, 10, 'Adres: ' . $offer['customer_address'], 0, 1);
        $this->Cell(0, 10, 'Tarih: ' . $offer['created_at'], 0, 1);
        $this->Ln(10);
    }
    
    function ItemsTable($header, $data) {
        $w = array(110, 20, 30, 30);
        
        $this->SetFillColor(230, 230, 230);
        $this->SetDrawColor(180, 180, 180);
        $this->SetLineWidth(.3);
        $this->SetFont('Arial', 'B', 10);
        
        // Tablo başlıkları
        $this->Cell($w[0], 7, $header[0], 1, 0, 'C', true);
        $this->Cell($w[1], 7, $header[1], 1, 0, 'C', true);
        $this->Cell($w[2], 7, $header[2], 1, 0, 'C', true);
        $this->Cell($w[3], 7, $header[3], 1, 1, 'C', true);
        
        $this->SetFillColor(255, 255, 255);
        $this->SetFont('Arial', '', 10);
        
        // Tablo verileri
        foreach($data as $row) {
            $this->Cell($w[0], 6, utf8_decode($row['item_description']), 'LR', 0, 'L');
            $this->Cell($w[1], 6, $row['quantity'], 'LR', 0, 'R');
            $this->Cell($w[2], 6, number_format($row['unit_price'], 2, ',', '.') . ' TL', 'LR', 0, 'R');
            $this->Cell($w[3], 6, number_format($row['total_price'], 2, ',', '.') . ' TL', 'LR', 1, 'R');
        }
        
        // Toplam fiyat
        $this->SetFont('Arial', 'B', 10);
        $this->Cell($w[0]+$w[1]+$w[2], 6, 'Genel Toplam:', 'LR', 0, 'R', true);
        $this->Cell($w[3], 6, number_format($offer['total_price'], 2, ',', '.') . ' TL', 'LR', 1, 'R', true);
        $this->Cell(array_sum($w), 0, '', 'T');
    }
}

// PDF oluşturma
$pdf = new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 12);
$pdf->OfferDetails($offer);

// PDF tablosunu oluşturun
$header = array('Is Kalemi', 'Miktar', 'Birim Fiyat', 'Toplam Fiyat');
$pdf->ItemsTable($header, $offer_items);

// PDF dosyasını çıktı olarak verin
$pdf->Output('D', 'Teklif-' . $offer['offer_no'] . '.pdf');