<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$message = '';
$message_type = '';
$db = new Database();
$conn = $db->getConnection();
$users = [];
try {
    $stmt = $conn->prepare("SELECT id, name FROM users WHERE role = 'employee' OR role = 'admin' ORDER BY name ASC");
    $stmt->execute();
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $project_name = $_POST['project_name'] ?? '';
    $contractor_company = $_POST['contractor_company'] ?? '';
    $address = $_POST['address'] ?? '';
    $price = $_POST['price'] ?? 0;
    $start_date = $_POST['start_date'] ?? date('Y-m-d');
    $end_date = $_POST['end_date'] ?? null;
    $number_of_independent_units = $_POST['number_of_independent_units'] ?? null;
    $total_construction_area = $_POST['total_construction_area'] ?? null;
    $description = $_POST['description'] ?? '';
    $status = $_POST['status'] ?? 'planning';
    $assigned_to_user_id = $_POST['assigned_to_user_id'] ?? null;
    $assigned_to_user_id = empty($assigned_to_user_id) ? null : $assigned_to_user_id;

    try {
        $stmt = $conn->prepare("INSERT INTO projects (project_name, contractor_company, address, price, start_date, end_date, number_of_independent_units, total_construction_area, description, status, assigned_to_user_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$project_name, $contractor_company, $address, $price, $start_date, $end_date, $number_of_independent_units, $total_construction_area, $description, $status, $assigned_to_user_id]);
        header('Location: projects.php');
        exit;
    } catch (PDOException $e) {
        $message = 'Hata: Proje oluşturulurken bir sorun oluştu. ' . $e->getMessage();
        $message_type = 'error';
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Yeni Proje Oluştur</title>
    <link rel="stylesheet" href="css/style.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
    <h2>Yeni Proje Oluştur</h2>
    <?php if ($message): ?>
        <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
            <?php echo htmlspecialchars($message); ?>
        </p>
    <?php endif; ?>
    <form action="create_project.php" method="POST">
        <div class="form-grid">
            <div class="form-group">
                <label for="project_name">Proje Adı *</label>
                <input type="text" id="project_name" name="project_name" required>
            </div>
            <div class="form-group">
                <label for="contractor_company">Müteahhit Firma *</label>
                <input type="text" id="contractor_company" name="contractor_company" required>
            </div>
            <div class="form-group full-width">
                <label for="address">Adres</label>
                <textarea id="address" name="address" rows="3"></textarea>
            </div>
            <div class="form-group">
                <label for="price">Fiyat (TL)</label>
                <input type="number" id="price" name="price" step="0.01" min="0">
            </div>
            <div class="form-group">
                <label for="start_date">Başlangıç Tarihi *</label>
                <input type="date" id="start_date" name="start_date" value="<?php echo date('Y-m-d'); ?>" required>
            </div>
            <div class="form-group">
                <label for="end_date">Bitiş Tarihi</label>
                <input type="date" id="end_date" name="end_date">
            </div>
            <div class="form-group">
                <label for="number_of_independent_units">Bağımsız Bölüm Sayısı</label>
                <input type="number" id="number_of_independent_units" name="number_of_independent_units" min="0">
            </div>
            <div class="form-group">
                <label for="total_construction_area">Toplam İnşaat Alanı (m²)</label>
                <input type="number" id="total_construction_area" name="total_construction_area" step="0.01" min="0">
            </div>
        </div>
        <div class="form-group full-width">
            <label for="description">Açıklama</label>
            <textarea id="description" name="description" rows="5"></textarea>
        </div>
        <div class="form-group full-width">
            <label for="assigned_to_user_id">Proje Sorumlusu</label>
            <select id="assigned_to_user_id" name="assigned_to_user_id">
                <option value="">Atama Yapma</option>
                <?php foreach ($users as $user): ?>
                    <option value="<?php echo $user['id']; ?>"><?php echo htmlspecialchars($user['name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-actions full-width">
            <button type="submit">Proje Oluştur</button>
        </div>
    </form>
</main>
</body>
</html>