<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$message = '';
$message_type = '';
$db = new Database();
$conn = $db->getConnection();
$offers = [];
try {
    $stmt = $conn->prepare("SELECT id, offer_no, customer_name FROM offers ORDER BY offer_date DESC");
    $stmt->execute();
    $offers = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $offer_id = $_POST['offer_id'] ?? null;
    $customer_name = $_POST['customer_name'] ?? '';
    $customer_email = $_POST['customer_email'] ?? '';
    $total_price = $_POST['total_price'] ?? 0;
    $notes = $_POST['notes'] ?? '';
    $sale_date = date('Y-m-d');
    $sale_no = 'SATIŞ-' . date('Y') . '-' . uniqid();
    try {
        $stmt = $conn->prepare("INSERT INTO sales (sale_no, offer_id, customer_name, customer_email, total_price, sale_date, notes) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$sale_no, $offer_id, $customer_name, $customer_email, $total_price, $sale_date, $notes]);
        $message = 'Yeni satış kaydı başarıyla oluşturuldu!';
        $message_type = 'success';
    } catch (PDOException $e) {
        $message = 'Hata: Satış kaydı oluşturulurken bir sorun oluştu. ' . $e->getMessage();
        $message_type = 'error';
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Yeni Satış Kaydı</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
    <h2>Yeni Satış Kaydı Oluştur</h2>
    <?php if ($message): ?>
        <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
            <?php echo htmlspecialchars($message); ?>
        </p>
    <?php endif; ?>
    <form action="create_sale.php" method="POST">
        <div class="form-grid">
            <div class="form-group">
                <label for="offer_id">İlgili Teklif:</label>
                <select id="offer_id" name="offer_id">
                    <option value="">İlişkilendirme Yok</option>
                    <?php foreach ($offers as $offer): ?>
                        <option value="<?php echo $offer['id']; ?>"><?php echo htmlspecialchars($offer['offer_no'] . ' - ' . $offer['customer_name']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <label for="customer_name">Müşteri Adı:</label>
                <input type="text" id="customer_name" name="customer_name" required>
            </div>
            <div class="form-group">
                <label for="customer_email">Müşteri E-posta:</label>
                <input type="email" id="customer_email" name="customer_email">
            </div>
            <div class="form-group">
                <label for="total_price">Toplam Fiyat (TL):</label>
                <input type="number" id="total_price" name="total_price" step="0.01" min="0" required>
            </div>
        </div>
        <div class="form-group full-width">
            <label for="notes">Notlar:</label>
            <textarea id="notes" name="notes" rows="5"></textarea>
        </div>
        <div class="form-actions full-width">
            <button type="submit">Satış Kaydet</button>
        </div>
    </form>
</main>
</body>
</html>