<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$message = '';
$message_type = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $title = $_POST['title'] ?? '';
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    $role = $_POST['role'] ?? 'employee';
    $hashed_password = password_hash($password, PASSWORD_BCRYPT);
    $db = new Database();
    $conn = $db->getConnection();
    try {
        $stmt = $conn->prepare("INSERT INTO users (name, title, email, password, role) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$name, $title, $email, $hashed_password, $role]);
        $message = 'Yeni kullanıcı başarıyla oluşturuldu!';
        $message_type = 'success';
    } catch (PDOException $e) {
        $message = 'Hata: Kullanıcı oluşturulurken bir sorun oluştu. ' . $e->getMessage();
        $message_type = 'error';
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Yeni Kullanıcı Ekle</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
    <h2>Yeni Kullanıcı Ekle</h2>
    <?php if ($message): ?>
        <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
            <?php echo htmlspecialchars($message); ?>
        </p>
    <?php endif; ?>
    <form action="create_user.php" method="POST">
        <div>
            <label for="name">Ad Soyad:</label>
            <input type="text" id="name" name="name" required>
        </div>
        <div>
            <label for="title">Ünvan:</label>
            <input type="text" id="title" name="title">
        </div>
        <div>
            <label for="email">E-posta:</label>
            <input type="email" id="email" name="email" required>
        </div>
        <div>
            <label for="password">Şifre:</label>
            <input type="password" id="password" name="password" required>
        </div>
        <div>
            <label for="role">Yetki:</label>
            <select id="role" name="role">
                <option value="employee">Çalışan</option>
                <option value="admin">Yönetici</option>
            </select>
        </div>
        <div>
            <button type="submit">Kullanıcı Ekle</button>
        </div>
    </form>
</main>
</body>
</html>