<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;

$userName = $_SESSION['user_name'];
$userRole = $_SESSION['user_role'];

// --- Takvim (Calendar) Logic ---

// DİKKAT: Gerçek uygulamada, Database sınıfını doğru şekilde başlatmanız ve kullanmanız gerekir.
// Varsayım: $db nesnesi bağlantıyı yönetir.
$db = new Database();

/**
 * Takvim etkinliklerini simüle eder. Gerçek uygulamada keşif, proje ve not tabloları sorgulanmalıdır.
 * PHP tarafı boş bırakıldı, çünkü verilerin kalıcılığı JS (localStorage) üzerinden yönetilecektir.
 */
function get_calendar_events($db) {
    $events = []; 
    return $events;
}

$events = get_calendar_events($db);
$events_json = json_encode($events);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hati App - Yönetim Paneli</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/style.css">
    <!-- Takvim için özel stil: Ana sayfadaki modül gridi ve takvim yan yana durması için düzenlendi -->
    <style>
        :root {
            --calendar-primary: #007bff; /* Bugün rengi */
            --calendar-discovery: #6a1b9a; /* Keşif rengi - Mor */
            --calendar-important-note: #c62828; /* Önemli Not rengi - Koyu Kırmızı */
            --calendar-note: #fbc02d; /* Not rengi - Sarı */
            --calendar-bg-light: #f8f9fa;
        }

        /* Ana Dashboard Yapısı: Menü ve Yan Panel (Logo + Takvim) yan yana */
        .dashboard-content {
            display: flex;
            gap: 24px;
            padding: 20px;
            max-width: 1200px;
            margin: 0 auto;
            align-items: flex-start; /* İçeriğin üstten başlamasını sağlar */
        }

        .main-modules {
            flex-grow: 1;
            max-width: 75%;
            min-width: 0; 
        }

        .side-panel {
            width: 300px;
            flex-shrink: 0;
            display: flex;
            flex-direction: column;
            gap: 30px;
            align-items: center;
        }

        /* Mobil Uyumlu Tasarım */
        @media (max-width: 1024px) {
            .dashboard-content {
                flex-direction: column;
            }
            .main-modules {
                max-width: 100%;
            }
            .side-panel {
                width: 100%;
                order: -1; /* Logo/Takvimi mobil görünümde üste taşır */
                max-width: 400px;
                margin: 0 auto;
            }
        }

        /* Takvim Stilleri */
        .calendar-card {
            background-color: white;
            padding: 15px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            width: 100%;
            max-width: 300px; 
            box-sizing: border-box;
        }

        .calendar-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .calendar-date-info {
            display: flex;
            flex-direction: column;
            line-height: 1.2;
        }

        .calendar-month {
            font-size: 18px;
            font-weight: 700;
            color: #333;
        }

        .calendar-year {
            font-size: 14px;
            color: #777;
        }

        .calendar-grid {
            display: grid;
            grid-template-columns: repeat(7, 1fr);
            gap: 4px;
            text-align: center;
        }

        .day-name {
            font-size: 12px;
            font-weight: 600;
            color: #777;
            padding: 5px 0;
        }

        .day-number-wrapper {
            position: relative;
            padding: 8px 0;
            font-size: 14px;
            cursor: pointer;
            border-radius: 8px;
            transition: background-color 0.2s;
            color: #333;
            height: 30px; /* Sabit yükseklik */
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column;
        }

        .day-number-wrapper:hover {
            background-color: var(--calendar-bg-light);
        }

        .current-day {
            background-color: var(--calendar-primary);
            color: white;
            font-weight: 700;
        }
        
        .current-day:hover {
            background-color: var(--calendar-primary);
        }

        .empty-day {
            visibility: hidden;
        }

        .event-marker {
            position: absolute;
            bottom: 2px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 2px;
        }

        .event-dot {
            width: 4px;
            height: 4px;
            border-radius: 50%;
        }

        .discovery-dot { background-color: var(--calendar-discovery); }
        .important-note-dot { background-color: var(--calendar-important-note); } /* Yeni Dot Rengi */
        .note-dot { background-color: var(--calendar-note); }

        /* Etkinlik Detay Modalı */
        .event-modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            visibility: hidden;
            opacity: 0;
            transition: opacity 0.3s, visibility 0.3s;
        }

        .event-modal.open {
            visibility: visible;
            opacity: 1;
        }

        .modal-content {
            background-color: white;
            padding: 25px;
            border-radius: 12px;
            width: 90%;
            max-width: 400px;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.2);
            position: relative;
        }

        .modal-content h3 {
            margin-top: 0;
            color: #333;
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
        }

        .modal-content ul {
            list-style: none;
            padding: 0;
        }

        .modal-content li {
            padding: 10px 0;
            border-bottom: 1px solid #eee;
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 15px;
        }

        .modal-content li:last-child {
            border-bottom: none;
        }

        .modal-content .event-type {
            font-weight: 600;
            min-width: 60px;
            text-align: right;
            flex-shrink: 0;
        }

        .event-type.Keşif { color: var(--calendar-discovery); }
        .event-type.ÖnemliNot { color: var(--calendar-important-note); }
        .event-type.Not { color: var(--calendar-note); }

        .close-btn {
            position: absolute;
            top: 10px;
            right: 15px;
            background: none;
            border: none;
            font-size: 24px;
            cursor: pointer;
            color: #777;
        }
        
        /* Yeni Not Ekleme Formu Stilleri */
        .add-form-group {
            margin-bottom: 15px;
        }
        .add-form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 600;
            color: #555;
        }
        .add-form-group input[type="text"],
        .add-form-group select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-sizing: border-box;
            font-size: 14px;
        }
        .add-form-group select {
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='%23777'%3E%3Cpath d='M7 10l5 5 5-5z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 10px center;
            background-size: 16px;
            cursor: pointer;
        }
        .save-btn {
            background-color: var(--calendar-primary);
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
            transition: background-color 0.2s;
        }
        .save-btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
<main>
    <div class="dashboard-content">
        <div class="main-modules">
            <div class="welcome-message">
                <h2>Hoş Geldiniz, <?php echo htmlspecialchars($userName); ?>!</h2>
                <p>Uygulamanın ana modüllerine buradan ulaşabilirsiniz.</p>
            </div>

            <div class="card-grid-menu">

                <a href="requests.php" class="dashboard-card-icon" style="color: #6a1b9a;">
                    <div class="card-icon-svg" style="background-color: #f3e5f5;">
                        <!-- Minimalist Icon: FileText (Talepler/Dosya) -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M15 2H9a1 1 0 0 0-1 1v18a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1Z"/>
                            <path d="M8 7h8"/>
                            <path d="M8 11h8"/>
                            <path d="M12 15h4"/>
                        </svg>
                    </div>
                    <span>Talepler</span>
                </a>

                <a href="discoveries.php" class="dashboard-card-icon" style="color: #00838f;">
                    <div class="card-icon-svg" style="background-color: #e0f7fa;">
                        <!-- Minimalist Icon: MapPin (Keşifler/Konum) -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M12 22s-8-4-8-10a8 8 0 0 1 16 0c0 6-8 10-8 10Z"/>
                            <circle cx="12" cy="10" r="3"/>
                        </svg>
                    </div>
                    <span>Keşifler</span>
                </a>
                
                <a href="offers.php" class="dashboard-card-icon" style="color: #ff3b30;">
                    <div class="card-icon-svg" style="background-color: #ffe0e0;">
                        <!-- Minimalist Icon: FileCheck (Teklifler/Onaylı Doküman) -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M15 2H9a1 1 0 0 0-1 1v18a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1Z"/>
                            <polyline points="9 11 11 13 15 9"/>
                        </svg>
                    </div>
                    <span>Teklifler</span>
                </a>

                <a href="projects.php" class="dashboard-card-icon" style="color: #d81b60;">
                    <div class="card-icon-svg" style="background-color: #fce4ec;">
                        <!-- Minimalist Icon: Kanban (Projeler/Görev Tahtası) -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <rect x="3" y="3" width="7" height="18" rx="2"/>
                            <rect x="14" y="3" width="7" height="12" rx="2"/>
                        </svg>
                    </div>
                    <span>Projeler</span>
                </a>
                
                <a href="stock.php" class="dashboard-card-icon" style="color: #ef6c00;">
                    <div class="card-icon-svg" style="background-color: #fff3e0;">
                        <!-- Minimalist Icon: Package (Stok/Paket) -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="m21 8-3-4H6L3 8l9 6z"/>
                            <path d="M3 8v10a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V8"/>
                            <path d="M7 14h10"/>
                        </svg>
                    </div>
                    <span>Stok</span>
                </a>

                <a href="purchase_requests.php" class="dashboard-card-icon" style="color: #039be5;">
                    <div class="card-icon-svg" style="background-color: #e3f2fd;">
                        <!-- Minimalist Icon: Truck (Satın Alma/Tedarik) -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M14 18V6a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v11a1 1 0 0 0 1 1h2"/>
                            <path d="M19 18H9s-1 1.5-1 3"/>
                            <path d="M10 22h4"/>
                            <path d="M18 22h4"/>
                        </svg>
                    </div>
                    <span>Satın Alma</span>
                </a>

                <a href="personel.php" class="dashboard-card-icon" style="color: #0277bd;">
                    <div class="card-icon-svg" style="background-color: #e1f5fe;">
                        <!-- Minimalist Icon: Users (Personel/Kullanıcılar) -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/>
                            <circle cx="9" cy="7" r="4"/>
                            <path d="M22 21v-2a4 4 0 0 0-3-3.87"/>
                            <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                        </svg>
                    </div>
                    <span>Personel</span>
                </a>

                <a href="muhasebe.php" class="dashboard-card-icon" style="color: #388e3c;">
                    <div class="card-icon-svg" style="background-color: #e8f5e9;">
                        <!-- Minimalist Icon: DollarSign (Muhasebe/Para) -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <line x1="12" x2="12" y1="2" y2="22"/>
                            <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                        </svg>
                    </div>
                    <span>Muhasebe</span>
                </a>

                <a href="quality.php" class="dashboard-card-icon" style="color: #00838f;">
                    <div class="card-icon-svg" style="background-color: #e0f7fa;">
                        <!-- Minimalist Icon: ShieldCheck (Kalite/Onaylı Kalkan) -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10Z"/>
                            <path d="m9 12 2 2 4-4"/>
                        </svg>
                    </div>
                    <span>Kalite</span>
                </a>
                
                <a href="araclar.php" class="dashboard-card-icon" style="color: #fbc02d;">
                    <div class="card-icon-svg" style="background-color: #fffde7;">
                        <!-- Minimalist Icon: Wrench (Araçlarımız/Aletler) -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M14.7 6.3a1 1 0 0 0 0 1.4l1.6 1.6a1 1 0 0 0 1.4 0l3.77-3.77a6 6 0 0 1 0-8.48l-2.94-2.94a6 6 0 0 1-8.48 0L3.7 7.53a1 1 0 0 0 0 1.4l1.6 1.6a1 1 0 0 0 1.4 0Z"/>
                            <path d="m18 13-1.6-1.6"/>
                            <path d="m2 22 2.9-2.9"/>
                            <path d="M16.68 15.32 18 14"/>
                        </svg>
                    </div>
                    <span>Araçlarımız</span>
                </a>
                
                <?php if ($userRole === 'admin'): ?>
                <a href="settings.php" class="dashboard-card-icon" style="color: #6a1b9a;">
                    <div class="card-icon-svg" style="background-color: #f3e5f5;">
                        <!-- Minimalist Icon: Settings (Ayarlar) -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M12.22 2h-.44a2 2 0 0 0-2 2v.44a2 2 0 0 1-.44 2h-1.66a2 2 0 0 0-2 2v1.66a2 2 0 0 1-2 2h-.44a2 2 0 0 0-2 2v.44a2 2 0 0 1 2 2h.44a2 2 0 0 0 2 2h1.66a2 2 0 0 1 2 2v.44a2 2 0 0 0 2 2h.44a2 2 0 0 0 2-2v-.44a2 2 0 0 1 2-2h1.66a2 2 0 0 0 2-2v-1.66a2 2 0 0 1 2-2h.44a2 2 0 0 0 2-2v-.44a2 2 0 0 1-2-2h-.44a2 2 0 0 0-2-2h-1.66a2 2 0 0 1-2-2V4a2 2 0 0 0-2-2Z"/>
                            <circle cx="12" cy="12" r="3"/>
                        </svg>
                    </div>
                    <span>Ayarlar</span>
                </a>
                <?php endif; ?>
                
                <a href="notes.php" class="dashboard-card-icon" style="color: #fbc02d;">
                    <div class="card-icon-svg" style="background-color: #fffde7;">
                        <!-- Minimalist Icon: StickyNote (Notlar) -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M15 2H9a1 1 0 0 0-1 1v18a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1Z"/>
                            <path d="M12 17v-4"/>
                            <path d="M10 15h4"/>
                        </svg>
                    </div>
                    <span>Notlar</span>
                </a>
                
               

            </div>
        </div>
        <div class="side-panel">
            <div class="dashboard-logo">
                <img src="img/logo.png" alt="Şirket Logosu">
            </div>
            
            <!-- Takvim Modülü Başlangıcı -->
            <div id="calendar-container" class="calendar-card">
                <div class="calendar-header">
                    <!-- Takvim Ay/Yıl Bilgisi -->
                    <div class="calendar-date-info">
                        <div id="calendar-month" class="calendar-month"></div>
                        <div id="calendar-year" class="calendar-year"></div>
                    </div>
                </div>
                <!-- Takvim Günleri Grid Alanı -->
                <div class="calendar-grid">
                    <div class="day-name">Pzt</div>
                    <div class="day-name">Sal</div>
                    <div class="day-name">Çar</div>
                    <div class="day-name">Per</div>
                    <div class="day-name">Cum</div>
                    <div class="day-name">Cmt</div>
                    <div class="day-name">Paz</div>
                    <!-- Takvim günleri buraya JS ile eklenecek -->
                </div>
                <!-- Etkinlik Açıklamaları -->
                <p style="font-size: 12px; color: #555; text-align: center; margin-top: 15px;">
                    <span style="display:inline-block; width: 8px; height: 8px; border-radius: 50%; background-color: #6a1b9a; margin-right: 5px;"></span> Keşif, 
                    <span style="display:inline-block; width: 8px; height: 8px; border-radius: 50%; background-color: #c62828; margin-right: 5px;"></span> Önemli Not,
                    <span style="display:inline-block; width: 8px; height: 8px; border-radius: 50%; background-color: #fbc02d; margin-right: 5px;"></span> Not
                </p>
            </div>
            <!-- Takvim Modülü Sonu -->

        </div>
    </div>
</main>

<!-- Etkinlik Detay/Ekleme Modalı -->
<div id="event-modal" class="event-modal" onclick="closeModal(event)">
    <div class="modal-content" onclick="event.stopPropagation()">
        <button class="close-btn" onclick="closeModal()">×</button>
        <h3 id="modal-date-title"></h3>
        
        <!-- Not Görüntüleme Alanı -->
        <div id="modal-view-content">
            <h4 style="margin-top: 0; color: #555;">Kayıtlı Etkinlikler</h4>
            <ul id="modal-events-list">
                <!-- Etkinlikler buraya JS ile eklenecek -->
            </ul>
        </div>

        <!-- Not Ekleme Formu -->
        <h4 style="margin-top: 20px; border-top: 1px solid #eee; padding-top: 15px; color: #555;">Yeni Etkinlik Ekle</h4>
        <div id="modal-add-content">
            <div class="add-form-group">
                <label for="event-title">Etkinlik Başlığı</label>
                <input type="text" id="event-title" placeholder="Toplantı, Keşif Başlığı vb." required>
            </div>
            <div class="add-form-group">
                <label for="event-type">Etkinlik Türü</label>
                <select id="event-type" required>
                    <option value="Not">Sarı Not (Not)</option>
                    <option value="Keşif">Mor Keşif (Keşif)</option>
                    <option value="Önemli Not">Kırmızı Önemli Not (Önemli Not)</option>
                </select>
            </div>
            <div id="save-error-message" style="color: var(--calendar-important-note); font-size: 13px; margin-bottom: 10px;"></div>
            <button class="save-btn" onclick="saveEvent()">Kaydet</button>
        </div>

    </div>
</div>

<div class="logout-container">
    <a href="logout.php" class="logout-btn">
        Çıkış Yap
    </a>
</div>

<script>
    // --- Kalıcılık Başlangıcı: localStorage'dan Etkinlikleri Yükle ---
    // Bu, sayfa yenilendiğinde verilerin kaybolmamasını sağlar (Tarayıcı tabanlı kalıcılık).
    // Gerçek bir çok kullanıcılı uygulama için bu veriler veritabanına kaydedilmelidir.
    const storedEventsJson = localStorage.getItem('calendarEvents');
    let events = {};

    if (storedEventsJson) {
        try {
            // localStorage'dan gelen JSON verisini JavaScript nesnesine çevir
            events = JSON.parse(storedEventsJson);
        } catch (e) {
            console.error("Kayıtlı etkinlikler yüklenirken hata oluştu:", e);
        }
    } 

    /**
     * Etkinlik nesnesini (events) tarayıcı depolamasına (localStorage) kaydeder.
     */
    function saveEventsToLocalStorage() {
        // Nesneyi JSON string'ine çevirerek kaydet
        localStorage.setItem('calendarEvents', JSON.stringify(events));
    }
    // --- Kalıcılık Sonu ---

    const calendarGrid = document.querySelector('.calendar-grid');
    const monthDisplay = document.getElementById('calendar-month');
    const yearDisplay = document.getElementById('calendar-year');
    const today = new Date(); // Bugünkü tarih

    /**
     * Takvimi belirtilen ay için oluşturur.
     */
    function renderCalendar(date) {
        const year = date.getFullYear();
        const month = date.getMonth(); 

        const monthNames = ["Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran",
                            "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"];
        
        // Görüntüleme başlığını güncelle
        monthDisplay.textContent = monthNames[month];
        yearDisplay.textContent = year;

        // Ayın ilk günü (JS: 0=Pazar, 1=Pzt...)
        const firstDayOfMonth = new Date(year, month, 1).getDay(); 
        const daysInMonth = new Date(year, month + 1, 0).getDate();

        // Gün isimlerinden sonraki tüm gün elementlerini temizle
        let dayElements = calendarGrid.querySelectorAll('.day-number-wrapper, .empty-day');
        dayElements.forEach(el => el.remove());

        // Haftanın başlangıcı Pzt (1) olduğu için boşluk hesaplama
        let startDayIndex = (firstDayOfMonth === 0 ? 6 : firstDayOfMonth - 1); 

        // Başlangıç boşluklarını ekle
        for (let i = 0; i < startDayIndex; i++) {
            const emptyDiv = document.createElement('div');
            emptyDiv.className = 'empty-day';
            calendarGrid.appendChild(emptyDiv);
        }

        // Günleri ekle
        for (let day = 1; day <= daysInMonth; day++) {
            const dayWrapper = document.createElement('div');
            dayWrapper.className = 'day-number-wrapper';
            dayWrapper.textContent = day;

            const currentDateString = `${year}-${String(month + 1).padStart(2, '0')}-${String(day).padStart(2, '0')}`;
            
            // Bugün kontrolü
            if (day === today.getDate() && month === today.getMonth() && year === today.getFullYear()) {
                dayWrapper.classList.add('current-day');
            }

            // Etkinlik işaretçilerini ekle
            if (events[currentDateString] && events[currentDateString].length > 0) {
                dayWrapper.classList.add('has-event');
                const eventMarker = document.createElement('div');
                eventMarker.className = 'event-marker';

                // Tüm etkinlik türlerini toplar
                const types = new Set(events[currentDateString].map(e => e.type));
                
                // Dotları türlerine göre ekle
                if (types.has('Keşif')) {
                    const dot = document.createElement('span');
                    dot.className = 'event-dot discovery-dot';
                    eventMarker.appendChild(dot);
                }
                if (types.has('Önemli Not')) {
                    const dot = document.createElement('span');
                    dot.className = 'event-dot important-note-dot';
                    eventMarker.appendChild(dot);
                }
                if (types.has('Not')) {
                    const dot = document.createElement('span');
                    dot.className = 'event-dot note-dot';
                    eventMarker.appendChild(dot);
                }
                
                // Sadece 3 farklı renk gösterilir
                while (eventMarker.children.length > 3) {
                    eventMarker.removeChild(eventMarker.lastChild);
                }
                
                dayWrapper.appendChild(eventMarker);
            } 
            
            // Tüm günlere tıklama olayını ekle
            dayWrapper.style.cursor = 'pointer'; 
            dayWrapper.addEventListener('click', () => openModal(currentDateString, day));

            calendarGrid.appendChild(dayWrapper);
        }
    }

    // Modal İşlevselliği
    const modal = document.getElementById('event-modal');
    const modalTitle = document.getElementById('modal-date-title');
    const modalList = document.getElementById('modal-events-list');
    const modalViewContent = document.getElementById('modal-view-content');
    const errorMessage = document.getElementById('save-error-message');
    let selectedDateString = ''; // Hangi tarihin seçildiğini tutmak için

    /**
     * Modal'ı açar ve seçilen gün için etkinlikleri gösterir/formu hazırlar.
     */
    function openModal(dateString, day) {
        selectedDateString = dateString; // Seçili tarihi kaydet
        modalTitle.textContent = `${day} ${monthDisplay.textContent} ${yearDisplay.textContent} Etkinlikleri`;
        
        const dayEvents = events[dateString] || [];
        modalList.innerHTML = '';
        errorMessage.textContent = ''; // Hata mesajını temizle
        
        if (dayEvents.length > 0) {
            // Etkinlik varsa, listeyi göster
            modalViewContent.style.display = 'block';
            dayEvents.forEach(event => {
                const li = document.createElement('li');
                let dotClass = '';
                // Etkinlik türlerini eşle ve li elementini oluştur
                if (event.type === 'Keşif') dotClass = 'discovery-dot';
                else if (event.type === 'Önemli Not') dotClass = 'important-note-dot';
                else if (event.type === 'Not') dotClass = 'note-dot';

                // Tür ismindeki boşlukları kaldırarak CSS sınıfını belirle
                const typeClass = event.type.replace(/\s/g, '');

                li.innerHTML = `
                    <span class="event-dot ${dotClass}" style="flex-shrink: 0;"></span>
                    <span class="event-type ${typeClass}">${event.type}:</span> 
                    <span style="flex-grow: 1;">${event.title}</span>
                `;
                modalList.appendChild(li);
            });
        } else {
            // Etkinlik yoksa, liste başlığını ve içeriğini gizle
            modalViewContent.style.display = 'none';
        }
        
        // Formu temizle
        document.getElementById('event-title').value = '';
        document.getElementById('event-type').value = 'Not';
        
        modal.classList.add('open');
    }
    
    /**
     * Not ekleme formundan gelen verileri kaydeder ve takvimi yeniden çizer.
     * (Artık localStorage'a da kaydedilir.)
     */
    function saveEvent() {
        const titleInput = document.getElementById('event-title');
        const typeInput = document.getElementById('event-type');

        const newTitle = titleInput.value.trim();
        const newType = typeInput.value;
        errorMessage.textContent = ''; // Hata mesajını temizle

        if (!newTitle) {
            errorMessage.textContent = "Lütfen bir etkinlik başlığı girin.";
            return;
        }

        const newEvent = {
            date: selectedDateString,
            type: newType,
            title: newTitle
        };

        // Yeni olayı yerel JS nesnesine ekle
        if (!events[selectedDateString]) {
            events[selectedDateString] = [];
        }
        events[selectedDateString].push(newEvent);

        // YENİ: Etkinlikleri localStorage'a kaydet (Kalıcılık için)
        saveEventsToLocalStorage(); 

        // Takvimi yeniden çiz ve modalı kapat
        renderCalendar(today);
        closeModal();
    }


    function closeModal(event) {
        // Modal içeriği tıklandığında kapanmayı engeller
        if (event && event.target.closest('.modal-content')) return;

        modal.classList.remove('open');
    }

    // Sayfa yüklendiğinde takvimi mevcut ay için render et
    document.addEventListener('DOMContentLoaded', () => {
        renderCalendar(today);
    });

</script>
</body>
</html>
