<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;

$message = '';
$message_type = '';
$redirect_url = 'dashboard.php';

// Silme şifresinin sizin verdiğiniz doğru hash'i
$hashed_delete_password = '$2y$10$0VadWpE2ylUMv2Eiin2gdON3Ey3RKZ5BPTTz9URbBbbxOqGVrSwQW';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $action = $_POST['action'] ?? '';
    if ($action === 'delete') {
        $item_id = $_POST['id'] ?? 0;
        $table_name = $_POST['table'] ?? '';
        $user_password_input = $_POST['password'] ?? '';

        if (password_verify($user_password_input, $hashed_delete_password)) {
            $allowed_tables = ['offers', 'sales', 'purchase_requests', 'projects', 'master_evaluations', 'company_evaluations', 'missing_jobs', 'technical_office_discoveries', 'technical_office_contracts', 'technical_office_progress_payments'];
            
            if (in_array($table_name, $allowed_tables)) {
                $db = new Database();
                $conn = $db->getConnection();
                $stmt_delete = $conn->prepare("DELETE FROM `$table_name` WHERE id = ?");
                $stmt_delete->execute([$item_id]);

                header('Location: ' . $_POST['redirect_url'] . '?status=success&message=' . urlencode('Kayıt başarıyla silindi.'));
                exit;
            } else {
                header('Location: ' . $_POST['redirect_url'] . '?status=error&message=' . urlencode('Geçersiz tablo adı.'));
                exit;
            }
        } else {
            header('Location: ' . $_POST['redirect_url'] . '?status=error&message=' . urlencode('Silme şifresi hatalı.'));
            exit;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Kayıt Silme Onayı</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
    <h2>Kayıt Silme Onayı</h2>
    <?php if (isset($_GET['id']) && isset($_GET['table']) && isset($_GET['redirect'])): ?>
    <div class="login-container">
        <p><strong>DİKKAT:</strong> Bu işlemi geri alamazsınız!</p>
        <p>Silmek istediğiniz kayıt ID: <strong><?php echo htmlspecialchars($_GET['id']); ?></strong></p>
        <p>İlgili tablo: <strong><?php echo htmlspecialchars($_GET['table']); ?></strong></p>
        <form action="delete.php" method="POST">
            <input type="hidden" name="action" value="delete">
            <input type="hidden" name="id" value="<?php echo htmlspecialchars($_GET['id']); ?>">
            <input type="hidden" name="table" value="<?php echo htmlspecialchars($_GET['table']); ?>">
            <input type="hidden" name="redirect_url" value="<?php echo htmlspecialchars($_GET['redirect']); ?>">
            <div>
                <label for="password">Silme Şifresi:</label>
                <input type="password" id="password" name="password" required>
            </div>
            <div>
                <button type="submit" style="background-color: red;">Silme İşlemini Onayla</button>
            </div>
        </form>
    </div>
    <?php else: ?>
        <p>Geçersiz silme isteği. Geri dönmek için <a href="dashboard.php">tıklayın</a>.</p>
    <?php endif; ?>
</main>
</body>
</html>