<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;

$db = new Database();
$conn = $db->getConnection();
$message = $_GET['message'] ?? '';
$message_type = $_GET['status'] ?? '';
$employee = null;

$personnel_id = $_GET['id'] ?? ($_POST['id'] ?? 0);

if ($personnel_id > 0) {
    try {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $full_name = $_POST['full_name'] ?? '';
            $title = $_POST['title'] ?? '';
            $email = $_POST['email'] ?? '';
            $phone = $_POST['phone'] ?? '';
            $hire_date = $_POST['hire_date'] ?? null;
            $salary = $_POST['salary'] ?? 0;
            $allowance = $_POST['allowance'] ?? 0;

            $stmt = $conn->prepare("UPDATE personnel SET full_name = ?, title = ?, email = ?, phone = ?, hire_date = ?, salary = ?, allowance = ? WHERE id = ?");
            $stmt->execute([$full_name, $title, $email, $phone, $hire_date, $salary, $allowance, $personnel_id]);
            
            $message = 'Çalışan bilgileri başarıyla güncellendi!';
            $message_type = 'success';
            header("Location: calisanlar.php?status=success&message=" . urlencode($message));
            exit;
        }

        $stmt = $conn->prepare("SELECT * FROM personnel WHERE id = ?");
        $stmt->execute([$personnel_id]);
        $employee = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$employee) {
            $message = 'Çalışan bulunamadı.';
            $message_type = 'error';
        }
    } catch (PDOException $e) {
        $message = 'Hata: ' . $e->getMessage();
        $message_type = 'error';
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Çalışan Düzenle</title>
    <link rel="stylesheet" href="css/style.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="header-actions">
    <h2>Çalışan Düzenle</h2>
    <a href="calisanlar.php" class="secondary-btn">Geri Dön</a>
</div>
<?php if ($message): ?>
    <p class="message" style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
        <?php echo htmlspecialchars($message); ?>
    </p>
<?php endif; ?>
<?php if ($employee): ?>
    <form action="edit_personnel.php?id=<?php echo htmlspecialchars($employee['id']); ?>" method="POST">
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($employee['id']); ?>">
        <div class="form-grid">
            <div class="form-group">
                <label for="full_name">Ad Soyad *</label>
                <input type="text" id="full_name" name="full_name" value="<?php echo htmlspecialchars($employee['full_name']); ?>" required>
            </div>
            <div class="form-group">
                <label for="title">Unvan</label>
                <input type="text" id="title" name="title" value="<?php echo htmlspecialchars($employee['title'] ?? ''); ?>">
            </div>
            <div class="form-group">
                <label for="email">E-posta *</label>
                <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($employee['email']); ?>" required>
            </div>
            <div class="form-group">
                <label for="phone">Telefon *</label>
                <input type="text" id="phone" name="phone" value="<?php echo htmlspecialchars($employee['phone'] ?? ''); ?>" required>
            </div>
            <div class="form-group">
                <label for="hire_date">İşe Giriş Tarihi *</label>
                <input type="date" id="hire_date" name="hire_date" value="<?php echo htmlspecialchars($employee['hire_date']); ?>" required>
            </div>
            <div class="form-group">
                <label for="salary">Maaş (TL)</label>
                <input type="number" id="salary" name="salary" step="0.01" min="0" value="<?php echo htmlspecialchars($employee['salary']); ?>">
            </div>
            <div class="form-group">
                <label for="allowance">Avans (TL)</label>
                <input type="number" id="allowance" name="allowance" step="0.01" min="0" value="<?php echo htmlspecialchars($employee['allowance']); ?>">
            </div>
        </div>
        <div class="form-actions">
            <button type="submit">Güncelle</button>
        </div>
    </form>
<?php else: ?>
    <p class="message" style="color: red;">Çalışan bilgileri yüklenemedi. Lütfen <a href="calisanlar.php">çalışanlar sayfasına</a> geri dönün.</p>
<?php endif; ?>
</main>
</body>
</html>