<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$db = new Database();
$conn = $db->getConnection();
$message = '';
$message_type = '';
$stock_item = null;
$item_id = $_REQUEST['id'] ?? 0;
if ($item_id > 0) {
    try {
        $stmt = $conn->prepare("SELECT * FROM stock_items WHERE id = ?");
        $stmt->execute([$item_id]);
        $stock_item = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$stock_item) {
            $message = 'Düzenlemek istediğiniz stok kaydı bulunamadı.';
            $message_type = 'error';
        }
    } catch (PDOException $e) {
        $message = 'Hata: ' . $e->getMessage();
        $message_type = 'error';
    }
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $stock_item) {
    $item_code = $_POST['item_code'] ?? $stock_item['item_code'];
    $item_name = $_POST['item_name'] ?? $stock_item['item_name'];
    $unit = $_POST['unit'] ?? $stock_item['unit'];
    $category = $_POST['category'] ?? $stock_item['category'];
    $brand = $_POST['brand'] ?? $stock_item['brand'];
    $model = $_POST['model'] ?? $stock_item['model'];
    $description = $_POST['description'] ?? $stock_item['description'];
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    try {
        $stmt = $conn->prepare("UPDATE stock_items SET item_code = ?, item_name = ?, unit = ?, category = ?, brand = ?, model = ?, description = ?, is_active = ? WHERE id = ?");
        $stmt->execute([$item_code, $item_name, $unit, $category, $brand, $model, $description, $is_active, $item_id]);
        $message = 'Stok kaydı başarıyla güncellendi.';
        $message_type = 'success';
        $stmt = $conn->prepare("SELECT * FROM stock_items WHERE id = ?");
        $stmt->execute([$item_id]);
        $stock_item = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $message = 'Güncelleme sırasında bir hata oluştu: ' . $e->getMessage();
        $message_type = 'error';
    }
}
if (!$stock_item && $item_id > 0) {
    echo "Hata: Stok kaydı bulunamadı.";
    exit;
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Stok Kaydı Düzenle: <?php echo htmlspecialchars($stock_item['item_code'] ?? ''); ?></title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
    <h2>Stok Kaydı Düzenle</h2>
    <?php if ($message): ?>
        <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
            <?php echo htmlspecialchars($message); ?>
        </p>
    <?php endif; ?>
    <?php if ($stock_item): ?>
    <form action="edit_stock.php" method="POST">
        <input type="hidden" name="id" value="<?php echo $stock_item['id']; ?>">
        <div class="form-grid">
            <div class="form-group">
                <label for="item_code">Kod *</label>
                <input type="text" id="item_code" name="item_code" value="<?php echo htmlspecialchars($stock_item['item_code']); ?>" required>
            </div>
            <div class="form-group">
                <label for="item_name">Malzeme Adı *</label>
                <input type="text" id="item_name" name="item_name" value="<?php echo htmlspecialchars($stock_item['item_name']); ?>" required>
            </div>
            <div class="form-group">
                <label for="unit">Birim Seçiniz *</label>
                <select id="unit" name="unit" required>
                    <option value="Adet" <?php echo $stock_item['unit'] === 'Adet' ? 'selected' : ''; ?>>Adet</option>
                    <option value="m" <?php echo $stock_item['unit'] === 'm' ? 'selected' : ''; ?>>m</option>
                    <option value="m2" <?php echo $stock_item['unit'] === 'm2' ? 'selected' : ''; ?>>m²</option>
                    <option value="kg" <?php echo $stock_item['unit'] === 'kg' ? 'selected' : ''; ?>>kg</option>
                </select>
            </div>
            <div class="form-group">
                <label for="category">Kategori Seçiniz</label>
                <input type="text" id="category" name="category" value="<?php echo htmlspecialchars($stock_item['category']); ?>">
            </div>
            <div class="form-group">
                <label for="brand">Marka Adı</label>
                <input type="text" id="brand" name="brand" value="<?php echo htmlspecialchars($stock_item['brand']); ?>">
            </div>
            <div class="form-group">
                <label for="model">Model Adı</label>
                <input type="text" id="model" name="model" value="<?php echo htmlspecialchars($stock_item['model']); ?>">
            </div>
        </div>
        <div class="form-group full-width">
            <label for="description">Açıklama</label>
            <textarea id="description" name="description" rows="5"><?php echo htmlspecialchars($stock_item['description']); ?></textarea>
        </div>
        <div class="form-group full-width">
            <label>
                <input type="checkbox" name="is_active" <?php echo $stock_item['is_active'] ? 'checked' : ''; ?>>
                Bütün Projelerde Aktif Kullanım
            </label>
        </div>
        <div class="form-actions full-width">
            <button type="submit">Güncelle</button>
        </div>
    </form>
    <?php endif; ?>
</main>
</body>
</html>