<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$db = new Database();
$conn = $db->getConnection();
$message = '';
$message_type = '';
$user = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_POST['id'] ?? 0;
    $name = $_POST['name'] ?? '';
    $title = $_POST['title'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $address = $_POST['address'] ?? '';
    $company_info = $_POST['company_info'] ?? '';
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    $role = $_POST['role'] ?? 'employee';
    $tc_no = $_POST['tc_no'] ?? '';
    $country = $_POST['country'] ?? '';
    $city = $_POST['city'] ?? '';
    try {
        if (!empty($password)) {
            $hashed_password = password_hash($password, PASSWORD_BCRYPT);
            $stmt = $conn->prepare("UPDATE users SET name = ?, title = ?, email = ?, phone = ?, address = ?, company_info = ?, password = ?, role = ?, tc_no = ?, country = ?, city = ? WHERE id = ?");
            $stmt->execute([$name, $title, $email, $phone, $address, $company_info, $hashed_password, $role, $tc_no, $country, $city, $user_id]);
        } else {
            $stmt = $conn->prepare("UPDATE users SET name = ?, title = ?, email = ?, phone = ?, address = ?, company_info = ?, role = ?, tc_no = ?, country = ?, city = ? WHERE id = ?");
            $stmt->execute([$name, $title, $email, $phone, $address, $company_info, $role, $tc_no, $country, $city, $user_id]);
        }
        $message = 'Kullanıcı bilgileri başarıyla güncellendi!';
        $message_type = 'success';
    } catch (PDOException $e) {
        $message = 'Hata: Kullanıcı güncellenirken bir sorun oluştu. ' . $e->getMessage();
        $message_type = 'error';
    }
}
$user_id = $_GET['id'] ?? ($_POST['id'] ?? 0);
if ($user_id > 0) {
    try {
        $stmt = $conn->prepare("SELECT id, name, title, email, role, created_at, phone, address, company_info, tc_no, country, city FROM users WHERE id = ?");
        $stmt->execute([$user_id]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$user) {
            $message = 'Kullanıcı bulunamadı.';
            $message_type = 'error';
        }
    } catch (PDOException $e) {
        $message = 'Hata: Kullanıcı bilgileri alınırken bir sorun oluştu. ' . $e->getMessage();
        $message_type = 'error';
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Kullanıcı Düzenle</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
    <h2>Kullanıcı Düzenle</h2>
    <?php if ($message): ?>
        <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
            <?php echo htmlspecialchars($message); ?>
        </p>
    <?php endif; ?>
    <?php if ($user): ?>
    <form action="edit_user.php" method="POST">
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($user['id']); ?>">
        <div class="form-grid">
            <div class="form-group">
                <label for="created_at">Eklenme Tarihi:</label>
                <input type="text" id="created_at" value="<?php echo htmlspecialchars($user['created_at']); ?>" disabled>
            </div>
            <div class="form-group">
                <label for="name">Ad Soyad:</label>
                <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($user['name']); ?>" required>
            </div>
            <div class="form-group">
                <label for="title">Ünvan:</label>
                <input type="text" id="title" name="title" value="<?php echo htmlspecialchars($user['title'] ?? ''); ?>">
            </div>
            <div class="form-group">
                <label for="tc_no">TC No:</label>
                <input type="text" id="tc_no" name="tc_no" value="<?php echo htmlspecialchars($user['tc_no'] ?? ''); ?>">
            </div>
            <div class="form-group">
                <label for="email">E-posta:</label>
                <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($user['email']); ?>" required>
            </div>
            <div class="form-group">
                <label for="phone">Telefon:</label>
                <input type="text" id="phone" name="phone" value="<?php echo htmlspecialchars($user['phone'] ?? ''); ?>">
            </div>
            <div class="form-group">
                <label for="country">Ülke:</label>
                <input type="text" id="country" name="country" value="<?php echo htmlspecialchars($user['country'] ?? ''); ?>">
            </div>
            <div class="form-group">
                <label for="city">Şehir:</label>
                <input type="text" id="city" name="city" value="<?php echo htmlspecialchars($user['city'] ?? ''); ?>">
            </div>
            <div class="form-group full-width">
                <label for="address">Adres:</label>
                <textarea id="address" name="address" rows="3"><?php echo htmlspecialchars($user['address'] ?? ''); ?></textarea>
            </div>
            <div class="form-group full-width">
                <label for="company_info">Firma Bilgileri:</label>
                <textarea id="company_info" name="company_info" rows="3"><?php echo htmlspecialchars($user['company_info'] ?? ''); ?></textarea>
            </div>
            <div class="form-group">
                <label for="password">Yeni Şifre:</label>
                <input type="password" id="password" name="password" placeholder="Şifreyi değiştirmek için doldurun">
            </div>
            <div class="form-group">
                <label for="role">Yetki:</label>
                <select id="role" name="role">
                    <option value="employee" <?php echo ($user['role'] === 'employee') ? 'selected' : ''; ?>>Çalışan</option>
                    <option value="admin" <?php echo ($user['role'] === 'admin') ? 'selected' : ''; ?>>Yönetici</option>
                </select>
            </div>
        </div>
        <div class="form-actions">
            <button type="submit">Güncelle</button>
        </div>
    </form>
    <?php else: ?>
        <p>Kullanıcı bilgileri yüklenemedi. Lütfen <a href="users.php">kullanıcılar sayfasına</a> geri dönün.</p>
    <?php endif; ?>
</main>
</body>
</html>