<?php
header('Content-Type: application/json');

if (!isset($_GET['item_id'])) {
    echo json_encode(['error' => 'item_id is required']);
    exit;
}

$item_id = (int)$_GET['item_id'];

require_once __DIR__ . '/../src/Core/Database.php';
use HatiApp\Core\Database;

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $stmt = $conn->prepare("SELECT sp.price, s.supplier_name, s.id as supplier_id FROM supplier_products sp JOIN suppliers s ON sp.supplier_id = s.id WHERE sp.stock_item_id = ? ORDER BY sp.price ASC");
    $stmt->execute([$item_id]);
    $suppliers = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($suppliers);

} catch (PDOException $e) {
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>