<?php
// Bu dosya, tüm fonksiyonları kendi içinde barındırır.
// Dosya yolu sorunlarını ortadan kaldırmak için tasarlanmıştır.

// Veritabanı bağlantı sınıfı (Dosya yolu sorunlarını önlemek için geçici olarak buraya taşındı)
class Database {
    private $host = 'localhost';
    private $dbname = 'sarelsgf_erp';
    private $username = 'sarelsgf_erp'; // Kendi MySQL kullanıcı adınız
    private $password = 'Qwer1907.'; // Kendi MySQL parolanız
    private $conn;

    public function __construct() {
        try {
            $this->conn = new PDO("mysql:host=$this->host;dbname=$this->dbname", $this->username, $this->password);
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            die("Veritabanı bağlantısı kurulamadı: " . $e->getMessage());
        }
    }

    public function getConnection() {
        return $this->conn;
    }
}

// Hata mesajını tutacak değişken
$error_message = '';

// Formun gönderilip gönderilmediğini kontrol et
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    // Veritabanı bağlantısı kur
    $db = new Database();
    $conn = $db->getConnection();

    try {
        // Kullanıcıyı e-posta ile veritabanında ara
        $stmt = $conn->prepare("SELECT id, name, password, role FROM users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        // Kullanıcı varsa ve parola doğruysa
        if ($user && password_verify($password, $user['password'])) {
            session_start();
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['name'];
            $_SESSION['user_role'] = $user['role'];

            header('Location: dashboard.php'); // Başarılıysa yönlendir
            exit;
        } else {
            $error_message = 'E-posta veya şifre hatalı.';
        }
    } catch (PDOException $e) {
        $error_message = 'Giriş işlemi sırasında bir hata oluştu: ' . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hati App - Giriş</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/style.css">
    <style>
        :root {
            --primary-color: #007bff;
            --background-start: #0056b3;
            --background-end: #0099ff;
            --card-bg: rgba(255, 255, 255, 0.95);
        }

        /* Arka Plan ve Sayfa Merkezi */
        body.login-page {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #000 0%, var(--background-end) 100%);
            font-family: Arial, sans-serif;
            color: #333;
        }

        /* Giriş Kartı */
        .login-container {
            width: 90%;
            max-width: 400px;
            padding: 40px;
            background-color: var(--card-bg);
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            text-align: center;
            backdrop-filter: blur(5px);
        }

        /* Başlık */
        .login-container h2 {
            font-size: 24px;
            color: var(--primary-color);
            margin-bottom: 30px;
            font-weight: 700;
        }
        
        /* Logo (Opsiyonel) */
        .login-logo {
            margin-bottom: 20px;
        }
        .login-logo img {
            width: 140px;
            height: auto;
        }

        /* Form Alanları */
        .login-container form > div {
            margin-bottom: 20px;
            text-align: left;
        }
        .login-container label {
            display: block;
            font-weight: 600;
            margin-bottom: 5px;
            color: #555;
            font-size: 14px;
        }
        .login-container input[type="email"],
        .login-container input[type="password"] {
            width: 100%;
            padding: 12px;
            border: 1px solid #ccc;
            border-radius: 8px;
            box-sizing: border-box;
            transition: border-color 0.3s, box-shadow 0.3s;
        }
        .login-container input:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
            outline: none;
        }

        /* Giriş Butonu */
        .login-container button[type="submit"] {
            width: 100%;
            padding: 12px;
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            transition: background-color 0.3s, transform 0.1s;
            box-shadow: 0 4px 10px rgba(0, 123, 255, 0.4);
        }
        .login-container button[type="submit"]:hover {
            background-color: #0056b3;
            transform: translateY(-1px);
        }

        /* Hata Mesajı */
        .error-message {
            color: white;
            background-color: #dc3545;
            padding: 10px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 600;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body class="login-page">
<div class="login-container">
    <div class="login-logo">
        <!-- Buraya şirket logonuzu ekleyebilirsiniz, örneğin: -->
        <img src="img/logo.png" alt="Hati App Logo">
    </div>
    <h2>Yönetim Paneli Giriş</h2>
    <?php if ($error_message): ?>
        <!-- Hata mesajı stili güncellendi -->
        <p class="error-message"><?php echo htmlspecialchars($error_message); ?></p>
    <?php endif; ?>
    <form action="login.php" method="POST">
        <div>
            <label for="email">E-posta:</label>
            <input type="email" id="email" name="email" required>
        </div>
        <div>
            <label for="password">Şifre:</label>
            <input type="password" id="password" name="password" required>
        </div>
        <div>
            <button type="submit">Giriş Yap</button>
        </div>
    </form>
</div>
</body>
</html>
