<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$db = new Database();
$conn = $db->getConnection();
$evaluations = [];
$message = '';
$message_type = '';
$masters = [];
$projects = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_evaluation') {
    $master_id = $_POST['master_id'] ?? null;
    $project_id = $_POST['project_id'] ?? null;
    $rating = $_POST['rating'] ?? 1;
    $notes = $_POST['notes'] ?? '';
    $evaluation_date = date('Y-m-d');
    $evaluator_user_id = $_SESSION['user_id'];
    try {
        $stmt = $conn->prepare("INSERT INTO master_evaluations (master_id, project_id, evaluator_user_id, evaluation_date, rating, notes) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$master_id, $project_id, $evaluator_user_id, $evaluation_date, $rating, $notes]);
        $message = 'Usta değerlendirmesi başarıyla eklendi!';
        $message_type = 'success';
    } catch (PDOException $e) {
        $message = 'Hata: Değerlendirme eklenirken bir sorun oluştu. ' . $e->getMessage();
        $message_type = 'error';
    }
}
try {
    $stmt_eval = $conn->prepare("SELECT me.*, m.master_name, u.name AS evaluator_user_name, p.project_name FROM master_evaluations me JOIN masters m ON me.master_id = m.id JOIN users u ON me.evaluator_user_id = u.id LEFT JOIN projects p ON me.project_id = p.id ORDER BY me.evaluation_date DESC");
    $stmt_eval->execute();
    $evaluations = $stmt_eval->fetchAll(PDO::FETCH_ASSOC);
    $stmt_masters = $conn->prepare("SELECT id, master_name FROM masters ORDER BY master_name ASC");
    $stmt_masters->execute();
    $masters = $stmt_masters->fetchAll(PDO::FETCH_ASSOC);
    $stmt_projects = $conn->prepare("SELECT id, project_name FROM projects ORDER BY project_name ASC");
    $stmt_projects->execute();
    $projects = $stmt_projects->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Usta Değerlendirmeleri</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
    <h2>Yeni Değerlendirme Ekle</h2>
    <?php if ($message): ?>
        <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
            <?php echo htmlspecialchars($message); ?>
        </p>
    <?php endif; ?>
    <form action="master_evaluations.php" method="POST">
        <input type="hidden" name="action" value="add_evaluation">
        <div>
            <label for="master_id">Değerlendirilen Kişi:</label>
            <select id="master_id" name="master_id" required>
                <?php foreach ($masters as $master): ?>
                    <option value="<?php echo $master['id']; ?>"><?php echo htmlspecialchars($master['master_name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="project_id">İlgili Proje:</label>
            <select id="project_id" name="project_id">
                <option value="">(Yok)</option>
                <?php foreach ($projects as $project): ?>
                    <option value="<?php echo $project['id']; ?>"><?php echo htmlspecialchars($project['project_name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="rating">Puan (1-5):</label>
            <input type="number" id="rating" name="rating" min="1" max="5" value="5" required>
        </div>
        <div>
            <label for="notes">Notlar:</label>
            <textarea id="notes" name="notes" rows="5"></textarea>
        </div>
        <div>
            <button type="submit">Değerlendirmeyi Kaydet</button>
        </div>
    </form>
    <hr>
    <h2>Mevcut Değerlendirmeler</h2>
    <?php if (empty($evaluations)): ?>
        <p>Henüz bir usta değerlendirmesi bulunmamaktadır.</p>
    <?php else: ?>
        <table>
            <thead>
                <tr>
                    <th>Değerlendirilen</th>
                    <th>Değerlendiren</th>
                    <th>Proje</th>
                    <th>Puan</th>
                    <th>Tarih</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($evaluations as $eval): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($eval['master_name']); ?></td>
                        <td><?php echo htmlspecialchars($eval['evaluator_user_name']); ?></td>
                        <td><?php echo htmlspecialchars($eval['project_name'] ?? '-'); ?></td>
                        <td><?php echo htmlspecialchars($eval['rating']); ?>/5</td>
                        <td><?php echo htmlspecialchars($eval['evaluation_date']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</main>
</body>
</html>