<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$db = new Database();
$conn = $db->getConnection();
$message = '';
$message_type = '';
$masters = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_master') {
    $master_name = $_POST['master_name'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $tc_no = $_POST['tc_no'] ?? '';
    try {
        $stmt = $conn->prepare("INSERT INTO masters (master_name, phone, tc_no) VALUES (?, ?, ?)");
        $stmt->execute([$master_name, $phone, $tc_no]);
        $message = 'Yeni usta başarıyla eklendi!';
        $message_type = 'success';
    } catch (PDOException $e) {
        $message = 'Hata: Usta eklenirken bir sorun oluştu. ' . $e->getMessage();
        $message_type = 'error';
    }
}
try {
    $stmt = $conn->prepare("SELECT * FROM masters ORDER BY master_name ASC");
    $stmt->execute();
    $masters = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hati App - Ustalar</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="header-actions">
    <h2>Ustalar</h2>
    <a href="#new-master">Yeni Usta Ekle</a>
</div>
<?php if ($message): ?>
    <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
        <?php echo htmlspecialchars($message); ?>
    </p>
<?php endif; ?>
<h3>Mevcut Ustalar</h3>
<?php if (empty($masters)): ?>
    <p>Sistemde kayıtlı usta bulunmamaktadır.</p>
<?php else: ?>
    <table>
        <thead>
            <tr>
                <th>İsim Soyisim</th>
                <th>Telefon</th>
                <th>TC No</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($masters as $master): ?>
            <tr>
                <td><?php echo htmlspecialchars($master['master_name']); ?></td>
                <td><?php echo htmlspecialchars($master['phone'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($master['tc_no'] ?? '-'); ?></td>
                <td>
                    <a href="view_master_evaluation.php?id=<?php echo $master['id']; ?>">Değerlendirme</a> |
                    <a href="create_master_evaluation.php?master_id=<?php echo $master['id']; ?>">Değerlendirme Yap</a> |
                    <a href="delete.php?table=masters&id=<?php echo $master['id']; ?>&redirect=masters.php" onclick="return confirm('Bu ustayı silmek istediğinizden emin misiniz?');">Sil</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>
<hr>
<h3 id="new-master">Yeni Usta Ekle</h3>
<form action="masters.php" method="POST">
    <input type="hidden" name="action" value="add_master">
    <div class="form-grid">
        <div class="form-group">
            <label for="master_name">Adı Soyadı *</label>
            <input type="text" id="master_name" name="master_name" required>
        </div>
        <div class="form-group">
            <label for="phone">Telefon Numarası</label>
            <input type="text" id="phone" name="phone">
        </div>
        <div class="form-group">
            <label for="tc_no">TC No</label>
            <input type="text" id="tc_no" name="tc_no">
        </div>
    </div>
    <div class="form-actions">
        <button type="submit">Usta Ekle</button>
    </div>
</form>
</main>
</body>
</html>