<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;

$db = new Database();
$conn = $db->getConnection();
$message = $_GET['message'] ?? '';
$message_type = $_GET['status'] ?? '';
$total_revenue = 0;
$total_offer_cost = 0;
$current_profit = 0;

// Kar/Zarar Dashboard verilerini çekme (basitleştirilmiş versiyon)
try {
    // 1. Toplam Gelir (Tekliflerin Toplam Satış Fiyatı)
    $stmt_revenue = $conn->prepare("SELECT SUM(total_price) as total_revenue FROM offers WHERE status = 'Kabul Edildi'");
    $stmt_revenue->execute();
    $total_revenue = $stmt_revenue->fetchColumn() ?? 0;

    // 2. Toplam Teklif Maliyeti (Kabul edilen tekliflerin toplam maliyeti)
    $stmt_cost = $conn->prepare("SELECT SUM(o.cost) 
                                 FROM offer_items oi 
                                 JOIN offers o ON oi.offer_id = o.id 
                                 WHERE o.status = 'Kabul Edildi'");
    // NOT: Bu sorgu, teklif kalemlerindeki maliyetleri doğru çekmeyebilir, 
    // ancak teklifler tablosuna kaydettiğimiz toplam maliyeti kullanacağız.
    // Varsayım: Teklif oluşturulurken hesaplanan toplam maliyet, offers tablosunda bir yerde tutuluyor olmalı.
    // Şimdilik sadece kabul edilen tekliflerin maliyetlerini (offers.cost sütunu varsa) toplayalım.
    // Eğer offers tablonuzda 'total_cost' sütunu yoksa, bu kısım boş kalacaktır.
    // Şimdilik kalemlerin maliyetini çekmek için bir sorgu kullanalım:
    $stmt_offer_cost = $conn->prepare("
        SELECT SUM(T2.cost * T2.quantity) 
        FROM offers T1 
        JOIN offer_items T2 ON T1.id = T2.offer_id 
        WHERE T1.status = 'Kabul Edildi'
    ");
    $stmt_offer_cost->execute();
    $total_offer_cost = $stmt_offer_cost->fetchColumn() ?? 0;


    // 3. Genel Giderler (Taşeron ve Malzeme ödemeleri)
    $stmt_general_expenses = $conn->prepare("SELECT SUM(amount) FROM finance_payments");
    $stmt_general_expenses->execute();
    $total_general_expenses = $stmt_general_expenses->fetchColumn() ?? 0;

    $current_profit = $total_revenue - $total_offer_cost - $total_general_expenses;

} catch (PDOException $e) {
    // Hata durumunda loglama veya uyarı
    // Bu sadece kar/zarar hesaplaması için, sayfanın geri kalanı çalışmalı.
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Muhasebe Yönetimi</title>
    <link rel="stylesheet" href="css/style.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .kpi-card {
            background: #fff;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            text-align: center;
        }
        .kpi-card h4 {
            color: var(--text-muted);
            margin-top: 0;
            font-size: 0.9em;
            text-transform: uppercase;
        }
        .kpi-card .value {
            font-size: 2.2em;
            font-weight: 700;
            margin: 5px 0 0;
        }
        .positive { color: var(--accent-green); }
        .negative { color: var(--accent-red); }
        .neutral { color: var(--accent-blue); }
        
        .action-button-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .action-button-grid a {
            display: block;
            padding: 20px;
            text-align: center;
            border-radius: 12px;
            font-size: 1.1em;
            font-weight: 600;
            text-decoration: none;
            color: #fff;
            transition: transform 0.2s, opacity 0.2s;
        }
        .action-button-grid a:hover {
            opacity: 0.9;
            transform: translateY(-2px);
        }
        .btn-tasaron { background-color: #007bff; }
        .btn-malzeme { background-color: #28a745; }
        .btn-cek { background-color: #ffc107; color: #333 !important; }
        .btn-takvim { background-color: #17a2b8; }
    </style>
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="header-actions">
    <h2>Muhasebe Yönetimi</h2>
</div>

<?php if ($message): ?>
    <p class="message" style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
        <?php echo htmlspecialchars($message); ?>
    </p>
<?php endif; ?>

<div class="detail-box">
    <h3 class="detail-box-title">Kar/Zarar Gösterge Paneli (Kabul Edilen Teklifler)</h3>
    <div class="dashboard-grid">
        <div class="kpi-card">
            <h4>Toplam Gelir (KDV Hariç)</h4>
            <p class="value neutral"><?php echo number_format($total_revenue, 2, ',', '.'); ?> TL</p>
        </div>
        <div class="kpi-card">
            <h4>Toplam Proje Maliyeti</h4>
            <p class="value negative"><?php echo number_format($total_offer_cost, 2, ',', '.'); ?> TL</p>
        </div>
        <div class="kpi-card">
            <h4>Genel Giderler (Taşeron + Malzeme)</h4>
            <p class="value negative"><?php echo number_format($total_general_expenses, 2, ',', '.'); ?> TL</p>
        </div>
        <div class="kpi-card">
            <h4>Anlık Kar Durumu</h4>
            <p class="value <?php echo $current_profit >= 0 ? 'positive' : 'negative'; ?>">
                <?php echo number_format($current_profit, 2, ',', '.'); ?> TL
            </p>
        </div>
    </div>
</div>

<div class="detail-box">
    <h3 class="detail-box-title">Finansal İşlemler</h3>
    <div class="action-button-grid">
       <a href="payments.php?type=Tasaron" class="btn-tasaron">Taşeron Ödemeleri</a>
<a href="payments.php?type=Malzeme" class="btn-malzeme">Malzeme Ödemeleri</a>
        <a href="checks.php" class="btn-cek">Çek Takibi</a>
        <a href="payment_calendar.php" class="btn-takvim">Ödeme Takvimi</a>
    </div>
</div>

</main>
</body>
</html>