<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;

$message = $_GET['message'] ?? '';
$message_type = $_GET['status'] ?? '';
$db = new Database();
$conn = $db->getConnection();
$personnel = [];
$ozluk_dosyalari = [];
$selected_personnel_id = $_GET['personnel_id'] ?? null;

// Belge kategorileri ve alt başlıkları
$document_categories = [
    'Kimlik ve Temel Belgeler' => [
        'Nüfus cüzdanı fotokopisi',
        'İkametgâh belgesi',
        'Vesikalık fotoğraf',
        'SGK işe giriş bildirgesi',
        'Adli sicil kaydı',
        'Diploma / öğrenim belgesi fotokopisi',
        'Askerlik durum belgesi (erkek çalışanlar için)',
    ],
    'İşe Alım Belgeleri' => [
        'İş başvuru formu',
        'Özgeçmiş (CV)',
        'Referans mektupları',
        'İş sözleşmesi (imzalı)',
        'İşe başlama formu / tutanağı',
        'Görev tanımı',
    ],
    'Ücret ve Mali Belgeler' => [
        'Ücret bordroları',
        'İzin formları (yıllık izin, mazeret izni, vs.)',
        'Avans ve kesinti formları',
        'Fazla mesai onay formu',
        'Performans değerlendirme formları',
    ],
    'Sağlık ve Eğitim Belgeleri' => [
        'İşe giriş sağlık raporu',
        'İş sağlığı ve güvenliği eğitim katılım formu',
        'Mesleki eğitim / sertifika belgeleri',
        'Acil durum bilgilendirme formu',
    ],
    'Diğer Belgeler' => [
        'Disiplin tutanakları',
        'Uyarı / savunma yazıları',
        'Zimmet teslim formları',
        'İşten ayrılış dilekçesi / çıkış formu',
        'SGK işten çıkış bildirgesi',
    ],
];

// Dosya yükleme işlemleri
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'upload_file') {
    $personnel_id = $_POST['personnel_id'] ?? 0;
    $document_name = $_POST['document_name'] ?? 'Diğer Belgeler';
    $category = $_POST['category'] ?? 'Diğer Belgeler';
    if (isset($_FILES['ozluk_dosyasi']) && $_FILES['ozluk_dosyasi']['error'] === UPLOAD_ERR_OK) {
        $file_name = $_FILES['ozluk_dosyasi']['name'];
        $file_tmp_name = $_FILES['ozluk_dosyasi']['tmp_name'];
        $upload_dir = __DIR__ . '/uploads/ozluk_dosyalari/';
        
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }

        $unique_file_name = uniqid() . '-' . basename($file_name);
        $destination = $upload_dir . $unique_file_name;

        if (move_uploaded_file($file_tmp_name, $destination)) {
            try {
                $stmt = $conn->prepare("INSERT INTO personnel_ozluk_dosyalari (personnel_id, document_name, file_path, category) VALUES (?, ?, ?, ?)");
                $stmt->execute([$personnel_id, $document_name, $destination, $category]);
                $message = 'Dosya başarıyla yüklendi!';
                $message_type = 'success';
                header("Location: ozluk_dosyalari.php?status=success&message=" . urlencode($message) . "&personnel_id=" . $personnel_id);
                exit;
            } catch (PDOException $e) {
                $message = 'Veritabanı hatası: ' . $e->getMessage();
                $message_type = 'error';
            }
        } else {
            $message = 'Dosya yüklenirken bir hata oluştu.';
            $message_type = 'error';
        }
    } else {
        $message = 'Lütfen geçerli bir dosya seçin.';
        $message_type = 'error';
    }
}

// Personel listesini al
try {
    $stmt = $conn->prepare("SELECT id, full_name FROM personnel ORDER BY full_name ASC");
    $stmt->execute();
    $personnel = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Yüklü dosyaları personel filtresine göre al
    $sql = "SELECT pod.*, p.full_name FROM personnel_ozluk_dosyalari pod JOIN personnel p ON pod.personnel_id = p.id";
    $params = [];
    if ($selected_personnel_id) {
        $sql .= " WHERE pod.personnel_id = ?";
        $params[] = $selected_personnel_id;
    }
    $sql .= " ORDER BY pod.upload_date DESC";
    
    $stmt_ozluk = $conn->prepare($sql);
    $stmt_ozluk->execute($params);
    $ozluk_dosyalari = $stmt_ozluk->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Hata: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hati App - Özlük Dosyaları</title>
    <link rel="stylesheet" href="css/style.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="header-actions">
    <h2>Özlük Dosyaları</h2>
    <a href="personel.php" class="secondary-btn">Geri Dön</a>
</div>

<?php if ($message): ?>
    <p class="message" style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
        <?php echo htmlspecialchars($message); ?>
    </p>
<?php endif; ?>

<div class="detail-box">
    <h3 class="detail-box-title">Dosya Yükle</h3>
    <form action="ozluk_dosyalari.php?personnel_id=<?php echo $selected_personnel_id; ?>" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="upload_file">
        <div class="form-grid">
            <div class="form-group">
                <label for="personnel_id">Personel Seç:</label>
                <select id="personnel_id" name="personnel_id" required>
                    <option value="">Seçiniz</option>
                    <?php foreach ($personnel as $p): ?>
                        <option value="<?php echo $p['id']; ?>" <?php echo $selected_personnel_id == $p['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($p['full_name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <label for="document_name">Belge Türü:</label>
                <select id="document_name" name="document_name" required>
                    <option value="">Seçiniz</option>
                    <?php foreach ($document_categories as $category => $documents): ?>
                        <optgroup label="<?php echo htmlspecialchars($category); ?>">
                            <?php foreach ($documents as $doc): ?>
                                <option value="<?php echo htmlspecialchars($doc); ?>"><?php echo htmlspecialchars($doc); ?></option>
                            <?php endforeach; ?>
                        </optgroup>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <label for="ozluk_dosyasi">Dosya Seç:</label>
                <input type="file" id="ozluk_dosyasi" name="ozluk_dosyasi" required>
            </div>
        </div>
        <div class="form-actions">
            <button type="submit">Dosya Yükle</button>
        </div>
    </form>
</div>

<div class="detail-box" style="margin-top: 2rem;">
    <h3 class="detail-box-title">Yüklü Özlük Dosyaları</h3>
    <div class="filter-controls">
        <label for="filter_personnel">Personel Seçerek Filtrele:</label>
        <select id="filter_personnel" onchange="window.location.href='ozluk_dosyalari.php?personnel_id=' + this.value">
            <option value="">Tüm Personel</option>
            <?php foreach ($personnel as $p): ?>
                <option value="<?php echo $p['id']; ?>" <?php echo $selected_personnel_id == $p['id'] ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($p['full_name']); ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <?php if (empty($ozluk_dosyalari)): ?>
        <p>Henüz özlük dosyası yüklenmemiştir.</p>
    <?php else: ?>
        <table>
            <thead>
                <tr>
                    <th>Dosya Adı</th>
                    <th>Personel</th>
                    <th>Belge Türü</th>
                    <th>Yükleme Tarihi</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($ozluk_dosyalari as $dosya): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($dosya['document_name']); ?></td>
                        <td><?php echo htmlspecialchars($dosya['full_name']); ?></td>
                        <td><?php echo htmlspecialchars($dosya['category']); ?></td>
                        <td><?php echo htmlspecialchars($dosya['upload_date']); ?></td>
                        <td>
                            <a href="download.php?file_id=<?php echo $dosya['id']; ?>&table=personnel_ozluk_dosyalari">İndir</a> |
                            <a href="delete.php?table=personnel_ozluk_dosyalari&id=<?php echo $dosya['id']; ?>&redirect=ozluk_dosyalari.php" onclick="return confirm('Bu dosyayı silmek istediğinizden emin misiniz?');">Sil</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

</body>
</html>