<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;

$userName = $_SESSION['user_name'];
$userRole = $_SESSION['user_role'];
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hati App - Personel Yönetimi</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
    <div class="header-actions">
        <h2>Personel Yönetimi</h2>
    </div>

    <div class="card-grid-menu">
        <a href="calisanlar.php" class="dashboard-card-icon" style="color: var(--primary);">
            <div class="card-icon-svg" style="background-color: var(--primary-light);">
                <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="currentColor" viewBox="0 0 256 256"><path d="M224,88V200a16,16,0,0,1-16,16H48a16,16,0,0,1-16-16V88a16,16,0,0,1,16-16H208A16,16,0,0,1,224,88Zm-16,112V88H48V200ZM80,32a8,8,0,0,0-8,8v16a8,8,0,0,0,16,0V40A8,8,0,0,0,80,32Zm96,0a8,8,0,0,0-8,8v16a8,8,0,0,0,16,0V40A8,8,0,0,0,176,32ZM128,128a8,8,0,0,0-8,8v16a8,8,0,0,0,16,0v-16A8,8,0,0,0,128,128Z"></path></svg>
            </div>
            <span>Çalışanlar</span>
        </a>

        <a href="subcontractors.php" class="dashboard-card-icon" style="color: var(--accent-purple);">
            <div class="card-icon-svg" style="background-color: #f3e5f5;">
                <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="currentColor" viewBox="0 0 256 256"><path d="M224,88V200a16,16,0,0,1-16,16H48a16,16,0,0,1-16-16V88a16,16,0,0,1,16-16H208A16,16,0,0,1,224,88Zm-16,112V88H48V200ZM80,32a8,8,0,0,0-8,8v16a8,8,0,0,0,16,0V40A8,8,0,0,0,80,32Zm96,0a8,8,0,0,0-8,8v16a8,8,0,0,0,16,0V40A8,8,0,0,0,176,32ZM128,128a8,8,0,0,0-8,8v16a8,8,0,0,0,16,0v-16A8,8,0,0,0,128,128Z"></path></svg>
            </div>
            <span>Taşeronlar</span>
        </a>

        <a href="ozluk_dosyalari.php" class="dashboard-card-icon" style="color: var(--accent-cyan);">
            <div class="card-icon-svg" style="background-color: #e3f2fd;">
                <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="currentColor" viewBox="0 0 256 256"><path d="M216,56V200a16,16,0,0,1-16,16H40a16,16,0,0,1-16-16V56a16,16,0,0,1,16-16H200A16,16,0,0,1,216,56ZM184,120a8,8,0,0,0-8-8H136V88a8,8,0,0,0-16,0v24H80a8,8,0,0,0,0,16h24v24a8,8,0,0,0,16,0V136h24a8,8,0,0,0,8-8Z"></path></svg>
            </div>
            <span>Özlük Dosyaları</span>
        </a>
        
        <a href="evraklar.php" class="dashboard-card-icon" style="color: var(--accent-orange);">
            <div class="card-icon-svg" style="background-color: #fff3e0;">
                <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="currentColor" viewBox="0 0 256 256"><path d="M216,40V216a8,8,0,0,1-16,0V40H56A16,16,0,0,0,40,56V216a16,16,0,0,0,16,16H200a16,16,0,0,0,16-16V56A16,16,0,0,0,200,40H216ZM120,88a8,8,0,0,1-16,0V56h16Zm40,0a8,8,0,0,1-16,0V56h16Z"></path></svg>
            </div>
            <span>Evraklar</span>
        </a>

        <a href="odemeler.php" class="dashboard-card-icon" style="color: var(--accent-green);">
            <div class="card-icon-svg" style="background-color: #e8f5e9;">
                <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="currentColor" viewBox="0 0 256 256"><path d="M228.69,79.31,136.69,31.31a16,16,0,0,0-17.38,0L27.31,79.31a16,16,0,0,0,0,21.38L120.62,152a16,16,0,0,0,17.38,0l93.31-51.31A16,16,0,0,0,228.69,79.31ZM128,168l-92.68-51.08,8.23-4.52,93.36,51.36a16,16,0,0,0,17.38,0l93.31-51.31,8.23,4.52L128,168Zm101.31-51.31-93.31,51.31a16,16,0,0,1-17.38,0L27.31,116.69a16,16,0,0,0-12,15.28V192a16,16,0,0,0,16,16H224a16,16,0,0,0,16-16V132A16,16,0,0,0,229.31,116.69Z"></path></svg>
            </div>
            <span>Ödemeler</span>
        </a>

        <a href="izinler.php" class="dashboard-card-icon" style="color: var(--primary);">
            <div class="card-icon-svg" style="background-color: #e3f2fd;">
                <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="currentColor" viewBox="0 0 256 256"><path d="M224,128a8,8,0,0,1-8,8H40a8,8,0,0,1,0-16H216A8,8,0,0,1,224,128ZM128,40a8,8,0,0,0-8,8V72a8,8,0,0,0,16,0V48A8,8,0,0,0,128,40ZM128,184a8,8,0,0,0-8,8v24a8,8,0,0,0,16,0V192A8,8,0,0,0,128,184Z"></path></svg>
            </div>
            <span>İzinler</span>
        </a>

        <a href="puantaj.php" class="dashboard-card-icon" style="color: var(--accent-cyan);">
            <div class="card-icon-svg" style="background-color: #e0f7fa;">
                <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="currentColor" viewBox="0 0 256 256"><path d="M224,128a8,8,0,0,1-8,8H176v40a8,8,0,0,1-16,0V136H96v40a8,8,0,0,1-16,0V136H40a8,8,0,0,1-8-8,8,8,0,0,1,8-8h32V80a8,8,0,0,1,16,0v40h64V80a8,8,0,0,1,16,0v40h32A8,8,0,0,1,224,128ZM128,40a8,8,0,0,0-8,8V72a8,8,0,0,0,16,0V48A8,8,0,0,0,128,40Z"></path></svg>
            </div>
            <span>Puantaj</span>
        </a>

    </div>
</main>
</body>
</html>