<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$db = new Database();
$conn = $db->getConnection();
$projects = [];
$message = $_GET['message'] ?? '';
$message_type = $_GET['status'] ?? '';
$query = "SELECT p.*, u.name as assigned_user_name FROM projects p LEFT JOIN users u ON p.assigned_to_user_id = u.id ORDER BY p.start_date DESC";
$params = [];
if ($_SESSION['user_role'] !== 'admin') {
    $query = "SELECT p.*, u.name as assigned_user_name FROM projects p LEFT JOIN users u ON p.assigned_to_user_id = u.id WHERE p.assigned_to_user_id = ? ORDER BY p.start_date DESC";
    $params[] = $_SESSION['user_id'];
}
try {
    $stmt = $conn->prepare($query);
    $stmt->execute($params);
    $projects = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hati App - Proje Yönetimi</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="header-actions">
    <h2>Projeler</h2>
    <?php if ($_SESSION['user_role'] === 'admin'): ?>
        <a href="create_project.php">Yeni Proje Oluştur</a>
    <?php endif; ?>
</div>
<?php if ($message): ?>
    <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
        <?php echo htmlspecialchars($message); ?>
    </p>
<?php endif; ?>
<?php if (empty($projects)): ?>
    <p>Henüz kayıtlı bir proje bulunmamaktadır.</p>
<?php else: ?>
    <table>
        <thead>
            <tr>
                <th>Proje Adı</th>
                <th>Müteahhit Firma</th>
                <th>Fiyat</th>
                <th>Başlangıç Tarihi</th>
                <th>Durum</th>
                <th>Atanan Kullanıcı</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($projects as $project): ?>
            <tr>
                <td><?php echo htmlspecialchars($project['project_name']); ?></td>
                <td><?php echo htmlspecialchars($project['contractor_company'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars(number_format($project['price'], 2, ',', '.') ?? '0,00'); ?> TL</td>
                <td><?php echo htmlspecialchars($project['start_date']); ?></td>
                <td>
                    <?php 
                    $statusInfo = getStatusInfo($project['status']); 
                    ?>
                    <span class="status <?php echo $statusInfo['class']; ?>"><?php echo $statusInfo['label']; ?></span>
                </td>
                <td><?php echo htmlspecialchars($project['assigned_user_name'] ?? 'Atanmadı'); ?></td>
                <td>
                    <a href="view_project.php?id=<?php echo $project['id']; ?>">Detaylar</a> |
                    <a href="delete.php?table=projects&id=<?php echo $project['id']; ?>&redirect=projects.php" onclick="return confirm('Bu kaydı silmek istediğinizden emin misiniz?');">Sil</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>
</main>
</body>
</html>