<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$db = new Database();
$conn = $db->getConnection();
$requests = [];
$message = $_GET['message'] ?? '';
$message_type = $_GET['status'] ?? '';

// Dashboard için veri çekme
$stats = [
    'pending_requests' => 0,
    'approved_requests' => 0,
    'ordered_requests' => 0,
    'completed_requests' => 0,
];
try {
    $stmt_pending = $conn->query("SELECT COUNT(*) FROM purchase_requests WHERE status = 'waiting_approval'");
    $stats['pending_requests'] = $stmt_pending->fetchColumn();
    $stmt_approved = $conn->query("SELECT COUNT(*) FROM purchase_requests WHERE status = 'approved'");
    $stats['approved_requests'] = $stmt_approved->fetchColumn();
    $stmt_ordered = $conn->query("SELECT COUNT(*) FROM purchase_requests WHERE status = 'ordered'");
    $stats['ordered_requests'] = $stmt_ordered->fetchColumn();
    $stmt_completed = $conn->query("SELECT COUNT(*) FROM purchase_requests WHERE status = 'completed'");
    $stats['completed_requests'] = $stmt_completed->fetchColumn();
    
    $stmt = $conn->prepare("SELECT pr.*, u.name as user_name, si.item_name, p.project_name, s.supplier_name FROM purchase_requests pr JOIN users u ON pr.requested_by_user_id = u.id LEFT JOIN stock_items si ON pr.item_id = si.id LEFT JOIN projects p ON pr.project_id = p.id LEFT JOIN suppliers s ON pr.supplier_id = s.id ORDER BY pr.request_date DESC");
    $stmt->execute();
    $requests = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hati App - Ürün Talepleri</title>
    <link rel="stylesheet" href="css/style.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="header-actions">
    <h2>Ürün Talepleri</h2>
    <div class="action-buttons">
        <a href="create_purchase_request.php">Yeni Talep Oluştur</a>
        <a href="suppliers.php" class="secondary-btn">Tedarikçi Firmalar</a>
        <a href="subcontractors.php" class="secondary-btn">Taşeron Firmalar</a>
    </div>
</div>
<div class="card-grid-menu">
    <div class="dashboard-card-icon" style="color: #ffc107;">
        <div class="card-icon-svg" style="background-color: #fff8e1;">
            <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="#ffc107" viewBox="0 0 256 256"><path d="M232,128a104,104,0,1,1-104-104A104.11,104.11,0,0,1,232,128Zm-8,0a96,96,0,1,0-96,96A96.11,96.11,0,0,0,224,128Zm-96,40a8,8,0,0,1-16,0V128a8,8,0,0,1,16,0Zm0-56a12,12,0,1,1-12-12A12,12,0,0,1,128,112Z"></path></svg>
        </div>
        <span>Onay Bekleyenler</span>
        <p class="stat-number"><?php echo $stats['pending_requests']; ?></p>
    </div>
    <div class="dashboard-card-icon" style="color: #28a745;">
        <div class="card-icon-svg" style="background-color: #e6ffed;">
            <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="#28a745" viewBox="0 0 256 256"><path d="M128,24A104,104,0,1,0,232,128,104.11,104.11,0,0,0,128,24Zm0,192a88,88,0,1,1,88-88A88.1,88.1,0,0,1,128,216Zm41.66-136.34-56,56a8,8,0,0,1-11.32,0l-24-24a8,8,0,0,1,11.32-11.32L112,148.68l50.34-50.34a8,8,0,0,1,11.32,11.32Z"></path></svg>
        </div>
        <span>Onaylananlar</span>
        <p class="stat-number"><?php echo $stats['approved_requests']; ?></p>
    </div>
    <div class="dashboard-card-icon" style="color: #039be5;">
        <div class="card-icon-svg" style="background-color: #e3f2fd;">
            <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="#039be5" viewBox="0 0 256 256"><path d="M216,56V200a16,16,0,0,1-16,16H40a16,16,0,0,1-16-16V56a16,16,0,0,1,16-16H200A16,16,0,0,1,216,56ZM184,120a8,8,0,0,0-8-8H136V88a8,8,0,0,0-16,0v24H80a8,8,0,0,0,0,16h24v24a8,8,0,0,0,16,0V136h24a8,8,0,0,0,8-8Z"></path></svg>
        </div>
        <span>Sipariş Edilenler</span>
        <p class="stat-number"><?php echo $stats['ordered_requests']; ?></p>
    </div>
    <div class="dashboard-card-icon" style="color: #6a1b9a;">
        <div class="card-icon-svg" style="background-color: #f3e5f5;">
            <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="#6a1b9a" viewBox="0 0 256 256"><path d="M216,40V216a8,8,0,0,1-16,0V40H56A16,16,0,0,0,40,56V216a16,16,0,0,0,16,16H200a16,16,0,0,0,16-16V56A16,16,0,0,0,200,40H216ZM120,88a8,8,0,0,1-16,0V56h16Zm40,0a8,8,0,0,1-16,0V56h16Z"></path></svg>
        </div>
        <span>Tamamlananlar</span>
        <p class="stat-number"><?php echo $stats['completed_requests']; ?></p>
    </div>
</div>

<?php if ($message): ?>
    <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
        <?php echo htmlspecialchars($message); ?>
    </p>
<?php endif; ?>
<h3>Mevcut Ürün Talepleri</h3>
<?php if (empty($requests)): ?>
    <p>Henüz kayıtlı bir ürün talebi bulunmamaktadır.</p>
<?php else: ?>
    <table>
        <thead>
            <tr>
                <th>Talep No</th>
                <th>Talep Eden</th>
                <th>Bölüm</th>
                <th>Proje Adı</th>
                <th>Ürün Adı</th>
                <th>Tedarikçi</th>
                <th>Miktar</th>
                <th>Durum</th>
                <th>Alım Tarihi</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($requests as $request): ?>
            <tr>
                <td><?php echo htmlspecialchars($request['request_no']); ?></td>
                <td><?php echo htmlspecialchars($request['user_name']); ?></td>
                <td><?php echo htmlspecialchars($request['department']); ?></td>
                <td><?php echo htmlspecialchars($request['project_name'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($request['item_name'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($request['supplier_name'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($request['quantity']); ?></td>
                <td>
                    <?php 
                    $statusInfo = getStatusInfo($request['status']); 
                    ?>
                    <span class="status <?php echo $statusInfo['class']; ?>"><?php echo $statusInfo['label']; ?></span>
                </td>
                <td><?php echo htmlspecialchars($request['received_date'] ?? '-'); ?></td>
                <td>
                    <a href="view_purchase_request.php?id=<?php echo $request['id']; ?>">Detaylar</a> |
                    <a href="delete.php?table=purchase_requests&id=<?php echo $request['id']; ?>&redirect=purchase_requests.php" onclick="return confirm('Bu kaydı silmek istediğinizden emin misiniz?');">Sil</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>
</main>
</body>
</html>