<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;

$message = $_GET['message'] ?? '';
$message_type = $_GET['status'] ?? '';

$db = new Database();
$conn = $db->getConnection();
$requests = [];

// Dashboard için veri çekme
$stats = [
    'pending_requests' => 0,
    'approved_requests' => 0,
    'rejected_requests' => 0,
    'total_requests' => 0
];

try {
    $stmt_pending = $conn->query("SELECT COUNT(*) FROM requests WHERE status = 'pending'");
    $stats['pending_requests'] = $stmt_pending->fetchColumn();

    $stmt_approved = $conn->query("SELECT COUNT(*) FROM requests WHERE status = 'approved'");
    $stats['approved_requests'] = $stmt_approved->fetchColumn();

    $stmt_rejected = $conn->query("SELECT COUNT(*) FROM requests WHERE status = 'rejected'");
    $stats['rejected_requests'] = $stmt_rejected->fetchColumn();

    $stmt_total = $conn->query("SELECT COUNT(*) FROM requests");
    $stats['total_requests'] = $stmt_total->fetchColumn();

    $stmt = $conn->prepare("SELECT r.*, u.name as created_by FROM requests r JOIN users u ON r.created_by_user_id = u.id ORDER BY r.request_date DESC");
    $stmt->execute();
    $requests = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Hata: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hati App - Talepler</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="header-actions">
    <h2>Gelen Talepler</h2>
    <a href="create_request.php">Yeni Talep Oluştur</a>
</div>
<div class="card-grid-menu">
    <div class="dashboard-card-icon" style="color: #6c757d;">
        <div class="card-icon-svg" style="background-color: #e9ecef;">
            <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="currentColor" viewBox="0 0 256 256"><path d="M224,128a8,8,0,0,1-8,8H40a8,8,0,0,1,0-16H216A8,8,0,0,1,224,128ZM128,40a8,8,0,0,0-8,8V72a8,8,0,0,0,16,0V48A8,8,0,0,0,128,40ZM128,184a8,8,0,0,0-8,8v24a8,8,0,0,0,16,0V192A8,8,0,0,0,128,184Z"></path></svg>
        </div>
        <span>Toplam Talep</span>
        <p class="stat-number"><?php echo $stats['total_requests']; ?></p>
    </div>
    <div class="dashboard-card-icon" style="color: #ffc107;">
        <div class="card-icon-svg" style="background-color: #fff8e1;">
            <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="currentColor" viewBox="0 0 256 256"><path d="M232,128a104,104,0,1,1-104-104A104.11,104.11,0,0,1,232,128Zm-8,0a96,96,0,1,0-96,96A96.11,96.11,0,0,0,224,128Zm-96,40a8,8,0,0,1-16,0V128a8,8,0,0,1,16,0Zm0-56a12,12,0,1,1-12-12A12,12,0,0,1,128,112Z"></path></svg>
        </div>
        <span>Bekleyenler</span>
        <p class="stat-number"><?php echo $stats['pending_requests']; ?></p>
    </div>
    <div class="dashboard-card-icon" style="color: #28a745;">
        <div class="card-icon-svg" style="background-color: #e6ffed;">
            <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="currentColor" viewBox="0 0 256 256"><path d="M128,24A104,104,0,1,0,232,128,104.11,104.11,0,0,0,128,24Zm0,192a88,88,0,1,1,88-88A88.1,88.1,0,0,1,128,216Zm41.66-136.34-56,56a8,8,0,0,1-11.32,0l-24-24a8,8,0,0,1,11.32-11.32L112,148.68l50.34-50.34a8,8,0,0,1,11.32,11.32Z"></path></svg>
        </div>
        <span>Onaylananlar</span>
        <p class="stat-number"><?php echo $stats['approved_requests']; ?></p>
    </div>
    <div class="dashboard-card-icon" style="color: #dc3545;">
        <div class="card-icon-svg" style="background-color: #ffe6e6;">
            <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="currentColor" viewBox="0 0 256 256"><path d="M224,128a8,8,0,0,1-8,8H40a8,8,0,0,1,0-16H216A8,8,0,0,1,224,128Z"></path></svg>
        </div>
        <span>Reddedilenler</span>
        <p class="stat-number"><?php echo $stats['rejected_requests']; ?></p>
    </div>
</div>
<?php if ($message): ?>
    <p class="message" style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
        <?php echo htmlspecialchars($message); ?>
    </p>
<?php endif; ?>
<h3>Mevcut Talepler</h3>
<?php if (empty($requests)): ?>
    <p>Henüz kayıtlı bir talep bulunmamaktadır.</p>
<?php else: ?>
    <div class="list-card-container">
        <?php foreach ($requests as $request): ?>
            <div class="list-card">
                <div class="list-card-content">
                    <div class="list-card-title"><?php echo htmlspecialchars($request['customer_name'] . ' ' . $request['customer_surname']); ?></div>
                    <div class="list-card-meta">
                        <span>Telefon: <?php echo htmlspecialchars($request['phone_number']); ?></span> |
                        <span>Oluşturan: <?php echo htmlspecialchars($request['created_by']); ?></span> |
                        <span>Tarih: <?php echo htmlspecialchars($request['request_date']); ?></span>
                    </div>
                </div>
                <div class="list-card-actions">
                    <?php 
                    $statusInfo = getStatusInfo($request['status']); 
                    ?>
                    <span class="status <?php echo $statusInfo['class']; ?>"><?php echo $statusInfo['label']; ?></span>
                    <a href="view_request.php?id=<?php echo $request['id']; ?>" class="view-btn">Gör</a>
                    <a href="delete.php?table=requests&id=<?php echo $request['id']; ?>&redirect=requests.php" class="delete-btn" onclick="return confirm('Bu kaydı silmek istediğinizden emin misiniz?');">Sil</a>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>
</main>
</body>
</html>