<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$db = new Database();
$conn = $db->getConnection();
$message = $_GET['message'] ?? '';
$message_type = $_GET['status'] ?? '';
$subcontractors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_subcontractor') {
    $subcontractor_name = $_POST['subcontractor_name'] ?? '';
    $contact_person = $_POST['contact_person'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $email = $_POST['email'] ?? '';
    $address = $_POST['address'] ?? '';
    try {
        $stmt = $conn->prepare("INSERT INTO subcontractors (subcontractor_name, contact_person, phone, email, address) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$subcontractor_name, $contact_person, $phone, $email, $address]);
        $message = 'Yeni taşeron firma başarıyla eklendi!';
        $message_type = 'success';
    } catch (PDOException $e) {
        $message = 'Hata: Firma eklenirken bir sorun oluştu. ' . $e->getMessage();
        $message_type = 'error';
    }
}
try {
    $stmt = $conn->prepare("SELECT * FROM subcontractors ORDER BY subcontractor_name ASC");
    $stmt->execute();
    $subcontractors = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hati App - Taşeron Firmalar</title>
    <link rel="stylesheet" href="css/style.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="header-actions">
    <h2>Taşeron Firmalar</h2>
    <a href="#new-subcontractor">Yeni Taşeron Ekle</a>
</div>
<?php if ($message): ?>
    <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
        <?php echo htmlspecialchars($message); ?>
    </p>
<?php endif; ?>
<h3>Mevcut Taşeronlar</h3>
<?php if (empty($subcontractors)): ?>
    <p>Sistemde kayıtlı taşeron firma bulunmamaktadır.</p>
<?php else: ?>
    <table>
        <thead>
            <tr>
                <th>Firma Adı</th>
                <th>Yetkili Kişi</th>
                <th>Telefon</th>
                <th>E-posta</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($subcontractors as $subcontractor): ?>
            <tr>
                <td><?php echo htmlspecialchars($subcontractor['subcontractor_name']); ?></td>
                <td><?php echo htmlspecialchars($subcontractor['contact_person'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($subcontractor['phone'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($subcontractor['email'] ?? '-'); ?></td>
                <td>
                    <a href="edit_subcontractor.php?id=<?php echo $subcontractor['id']; ?>">Düzenle</a> |
                    <a href="delete.php?table=subcontractors&id=<?php echo $subcontractor['id']; ?>&redirect=subcontractors.php" onclick="return confirm('Bu kaydı silmek istediğinizden emin misiniz?');">Sil</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>
<hr>
<h3 id="new-subcontractor">Yeni Taşeron Firma Ekle</h3>
<form action="subcontractors.php" method="POST">
    <input type="hidden" name="action" value="add_subcontractor">
    <div class="form-grid">
        <div class="form-group">
            <label for="subcontractor_name">Firma Adı *</label>
            <input type="text" id="subcontractor_name" name="subcontractor_name" required>
        </div>
        <div class="form-group">
            <label for="contact_person">Yetkili Kişi</label>
            <input type="text" id="contact_person" name="contact_person">
        </div>
        <div class="form-group">
            <label for="phone">Telefon Numarası</label>
            <input type="text" id="phone" name="phone">
        </div>
        <div class="form-group">
            <label for="email">E-posta</label>
            <input type="email" id="email" name="email">
        </div>
    </div>
    <div class="form-group full-width">
        <label for="address">Adres</label>
        <textarea id="address" name="address" rows="3"></textarea>
    </div>
    <div class="form-actions full-width">
        <button type="submit">Firma Ekle</button>
    </div>
</form>
</main>
</body>
</html>