<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$db = new Database();
$conn = $db->getConnection();
$message = $_GET['message'] ?? '';
$message_type = $_GET['status'] ?? '';
$suppliers = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_supplier') {
    $supplier_name = $_POST['supplier_name'] ?? '';
    $contact_person = $_POST['contact_person'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $email = $_POST['email'] ?? '';
    $address = $_POST['address'] ?? '';
    try {
        $stmt = $conn->prepare("INSERT INTO suppliers (supplier_name, contact_person, phone, email, address) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$supplier_name, $contact_person, $phone, $email, $address]);
        $message = 'Yeni tedarikçi firması başarıyla eklendi!';
        $message_type = 'success';
    } catch (PDOException $e) {
        $message = 'Hata: Firma eklenirken bir sorun oluştu. ' . $e->getMessage();
        $message_type = 'error';
    }
}
try {
    $stmt = $conn->prepare("SELECT * FROM suppliers ORDER BY supplier_name ASC");
    $stmt->execute();
    $suppliers = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hati App - Tedarikçi Firmalar</title>
    <link rel="stylesheet" href="css/style.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="header-actions">
    <h2>Tedarikçi Firmalar</h2>
    <a href="#new-supplier">Yeni Tedarikçi Ekle</a>
</div>
<?php if ($message): ?>
    <p style="color: <?php echo $message_type === 'success' ? 'green' : 'red'; ?>;">
        <?php echo htmlspecialchars($message); ?>
    </p>
<?php endif; ?>
<h3>Mevcut Tedarikçiler</h3>
<?php if (empty($suppliers)): ?>
    <p>Sistemde kayıtlı tedarikçi firma bulunmamaktadır.</p>
<?php else: ?>
    <table>
        <thead>
            <tr>
                <th>Firma Adı</th>
                <th>Yetkili Kişi</th>
                <th>Telefon</th>
                <th>E-posta</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($suppliers as $supplier): ?>
            <tr>
                <td><?php echo htmlspecialchars($supplier['supplier_name']); ?></td>
                <td><?php echo htmlspecialchars($supplier['contact_person'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($supplier['phone'] ?? '-'); ?></td>
                <td><?php echo htmlspecialchars($supplier['email'] ?? '-'); ?></td>
                <td>
                    <a href="edit_supplier.php?id=<?php echo $supplier['id']; ?>">Düzenle</a> |
                    <a href="delete.php?table=suppliers&id=<?php echo $supplier['id']; ?>&redirect=suppliers.php" onclick="return confirm('Bu kaydı silmek istediğinizden emin misiniz?');">Sil</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>
<hr>
<h3 id="new-supplier">Yeni Tedarikçi Firma Ekle</h3>
<form action="suppliers.php" method="POST">
    <input type="hidden" name="action" value="add_supplier">
    <div class="form-grid">
        <div class="form-group">
            <label for="supplier_name">Firma Adı *</label>
            <input type="text" id="supplier_name" name="supplier_name" required>
        </div>
        <div class="form-group">
            <label for="contact_person">Yetkili Kişi</label>
            <input type="text" id="contact_person" name="contact_person">
        </div>
        <div class="form-group">
            <label for="phone">Telefon Numarası</label>
            <input type="text" id="phone" name="phone">
        </div>
        <div class="form-group">
            <label for="email">E-posta</label>
            <input type="email" id="email" name="email">
        </div>
    </div>
    <div class="form-group full-width">
        <label for="address">Adres</label>
        <textarea id="address" name="address" rows="3"></textarea>
    </div>
    <div class="form-actions full-width">
        <button type="submit">Firma Ekle</button>
    </div>
</form>
</main>
</body>
</html>