<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$db = new Database();
$conn = $db->getConnection();
$master = null;
$master_id = $_GET['id'] ?? 0;
if ($master_id > 0) {
    try {
        $stmt_master = $conn->prepare("SELECT id, master_name, phone, tc_no FROM masters WHERE id = ?");
        $stmt_master->execute([$master_id]);
        $master = $stmt_master->fetch(PDO::FETCH_ASSOC);
        $stmt_eval = $conn->prepare("SELECT AVG(technical_skill_rating) AS technical_skill_avg, AVG(quality_attention_rating) AS quality_attention_avg, AVG(time_management_rating) AS time_management_avg, AVG(problem_solving_rating) AS problem_solving_avg, AVG(communication_rating) AS communication_avg, AVG(work_discipline_rating) AS work_discipline_avg, AVG(customer_satisfaction_rating) AS customer_satisfaction_avg, AVG(innovation_rating) AS innovation_avg, AVG(resource_usage_rating) AS resource_usage_avg, AVG(overall_rating) AS overall_avg FROM master_evaluations WHERE master_id = ?");
        $stmt_eval->execute([$master_id]);
        $averages = $stmt_eval->fetch(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        die("Hata: " . $e->getMessage());
    }
}
if (!$master) {
    die("Usta bulunamadı.");
}
$evaluations_count = 0;
$avg_overall_rating = 0;
if ($averages && $averages['overall_avg'] !== null) {
    $avg_overall_rating = $averages['overall_avg'];
    $stmt_count = $conn->prepare("SELECT COUNT(*) FROM master_evaluations WHERE master_id = ?");
    $stmt_count->execute([$master_id]);
    $evaluations_count = $stmt_count->fetchColumn();
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Usta Değerlendirme Raporu: <?php echo htmlspecialchars($master['master_name']); ?></title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
<div class="master-evaluation-container">
    <div class="evaluation-card">
        <h3 class="card-title">ERP Bölümümüzde Usta Değerlendirme</h3>
        <hr>
        <div class="master-card-header">
            <div class="master-avatar-circle">
                <img src="https://via.placeholder.com/60" alt="Usta Resmi">
            </div>
            <div class="master-details-grid">
                <div><strong>Usta İsim Soyisim:</strong> <?php echo htmlspecialchars($master['master_name']); ?></div>
                <div><strong>Telefon Numarası:</strong> <?php echo htmlspecialchars($master['phone'] ?? '-'); ?></div>
                <div><strong>TC No:</strong> <?php echo htmlspecialchars($master['tc_no'] ?? '-'); ?></div>
            </div>
        </div>
        <hr>
        <div class="evaluation-report">
            <h4>Değerlendirme</h4>
            <?php 
            $criteria = [
                'technical_skill_avg' => 'Teknik Yeterlilik',
                'quality_attention_avg' => 'İş Kalitesi / Detaylara Özen',
                'time_management_avg' => 'Zaman Yönetimi',
                'problem_solving_avg' => 'Problem Çözme Yeteneği',
                'communication_avg' => 'İletişim ve İşbirliği',
                'work_discipline_avg' => 'İş Disiplini',
                'customer_satisfaction_avg' => 'Müşteri Memnuniyeti',
                'innovation_avg' => 'Yenilik ve Öğrenmeye Açıklık',
                'resource_usage_avg' => 'Kaynak ve Malzeme Kullanımı'
            ];
            foreach ($criteria as $key => $label): 
                $percentage = ($averages[$key] ?? 0) * 10;
            ?>
            <div class="rating-row">
                <div class="rating-label"><?php echo $label; ?></div>
                <div class="rating-bar-container">
                    <div class="rating-bar" style="width: <?php echo $percentage; ?>%;"></div>
                </div>
                <div class="rating-percentage"><?php echo round($percentage); ?>%</div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>
</main>
</body>
</html>