<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
require_once __DIR__ . '/../src/Core/Database.php';
require_once __DIR__ . '/../src/Includes/helpers.php';
use HatiApp\Core\Database;
$sale = null;
$sale_id = $_GET['id'] ?? 0;
if ($sale_id > 0) {
    try {
        $db = new Database();
        $conn = $db->getConnection();
        $stmt = $conn->prepare("SELECT s.*, o.offer_no FROM sales s LEFT JOIN offers o ON s.offer_id = o.id WHERE s.id = ?");
        $stmt->execute([$sale_id]);
        $sale = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        echo "Hata: " . $e->getMessage();
    }
}
if (!$sale) {
    echo "Hata: Satış kaydı bulunamadı.";
    exit;
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Satış Detayı: <?php echo htmlspecialchars($sale['sale_no']); ?></title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
<?php require_once __DIR__ . '/../src/Includes/header.php'; ?>
    <h2>Satış Detayı</h2>
    <p><strong>Satış No:</strong> <?php echo htmlspecialchars($sale['sale_no']); ?></p>
    <p><strong>İlgili Teklif:</strong> <?php echo htmlspecialchars($sale['offer_no'] ?? '-'); ?></p>
    <p><strong>Müşteri Adı:</strong> <?php echo htmlspecialchars($sale['customer_name']); ?></p>
    <p><strong>Müşteri E-posta:</strong> <?php echo htmlspecialchars($sale['customer_email']); ?></p>
    <p><strong>Satış Tarihi:</strong> <?php echo htmlspecialchars($sale['sale_date']); ?></p>
    <p><strong>Toplam Fiyat:</strong> <?php echo number_format($sale['total_price'], 2, ',', '.'); ?> TL</p>
    <p><strong>Durum:</strong>
        <?php $statusInfo = getStatusInfo($sale['status']); ?>
        <span class="status <?php echo $statusInfo['class']; ?>"><?php echo $statusInfo['label']; ?></span>
    </p>
    <p><strong>Notlar:</strong></p>
    <pre><?php echo htmlspecialchars($sale['notes']); ?></pre>
</main>
</body>
</html>