<?php
// src/Includes/header.php
// Menü ikonları modern, renkli ve köşeleri yuvarlatılmış kareler (rounded square) olarak güncellenmiştir.
// Her ikon için özel renkler belirlenmiş, görseldeki "havalı" etki yaratılmaya çalışılmıştır.

// --- Renk Paleti Tanımlaması ---
// Her menü öğesi için özel renk ve gölge tanımları
$icon_styles = [
    'dashboard.php'       => ['bg' => '#f3e8ff', 'fill' => '#7c3aed', 'shadow' => 'rgba(124, 58, 237, 0.25)'], // Anasayfa - Mor
    'requests.php'        => ['bg' => '#e0f7fa', 'fill' => '#00bcd4', 'shadow' => 'rgba(0, 188, 212, 0.25)'], // Talepler - Turkuaz
    'discoveries.php'     => ['bg' => '#fff3e0', 'fill' => '#ff9800', 'shadow' => 'rgba(255, 152, 0, 0.25)'], // Keşifler - Turuncu
    'offers.php'          => ['bg' => '#ffebee', 'fill' => '#f44336', 'shadow' => 'rgba(244, 67, 54, 0.25)'], // Teklifler - Kırmızımsı Pembe
    'projects.php'        => ['bg' => '#e8eaf6', 'fill' => '#3f51b5', 'shadow' => 'rgba(63, 81, 181, 0.25)'], // Projeler - Lacivert
    'stock.php'           => ['bg' => '#e3f2fd', 'fill' => '#2196f3', 'shadow' => 'rgba(33, 150, 243, 0.25)'], // Stok - Açık Mavi
    'purchase_requests.php' => ['bg' => '#f1f8e9', 'fill' => '#8bc34a', 'shadow' => 'rgba(139, 195, 74, 0.25)'], // Satın Alma - Açık Yeşil
    'quality.php'         => ['bg' => '#fce4ec', 'fill' => '#e91e63', 'shadow' => 'rgba(233, 30, 99, 0.25)'], // Kalite - Fuşya
    'personel.php'        => ['bg' => '#fff8e1', 'fill' => '#ffc107', 'shadow' => 'rgba(255, 193, 7, 0.25)'], // Personel - Sarı
    'araclarimiz.php'     => ['bg' => '#e0f2f1', 'fill' => '#009688', 'shadow' => 'rgba(0, 150, 136, 0.25)'], // Araçlar - Petrol Yeşili
    // Admin ve Logout
    'muhasebe.php'        => ['bg' => '#fffde7', 'fill' => '#cddc39', 'shadow' => 'rgba(205, 220, 57, 0.25)'], // Muhasebe - Limon Yeşili
    'logout.php'          => ['bg' => '#fbe4e4', 'fill' => '#d32f2f', 'shadow' => 'rgba(211, 47, 47, 0.25)'], // Çıkış Yap - Kırmızı (Uyarı)
];

/**
 * Belirtilen sayfa yolu için CSS değişkenlerini içeren inline stil dizesini oluşturur.
 * Bu değişkenler, ikonun arka plan, dolgu ve gölge renklerini belirler.
 */
function get_icon_style($href, $styles) {
    $filename = basename($href);
    if (isset($styles[$filename])) {
        $s = $styles[$filename];
        // CSS Custom Properties (Değişkenler) kullanarak stil tanımlama
        return 'style="--icon-bg:' . $s['bg'] . '; --icon-fill:' . $s['fill'] . '; --icon-shadow:' . $s['shadow'] . ';"';
    }
    return '';
}
?>

<style>
/* * Genel Header ve Navigasyon Stili
 * NOT: Bu stiller sadece güncellenmiş ikon görünümünü sağlamak için eklenmiştir.
 * Mevcut projenizin global CSS'ine eklemeniz daha iyi olabilir.
 */
header {
    background-color: #04142d; /* Örnek Koyu Arka Plan Rengi */
    padding: 1rem 2rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #fff;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
}

.header-branding .header-logo {
    height: 120px; /* Logonuzun yüksekliğini ayarlayın */
}

.main-menu {
    list-style: none;
    display: flex;
    gap: 1.5rem; /* Menü öğeleri arasındaki boşluk */
    padding: 0;
    margin: 0;
}

.main-menu li {
    display: flex;
    align-items: center;
}

.main-menu a {
    display: flex;
    flex-direction: column; /* İkon ve metni alt alta dizer */
    align-items: center;
    text-decoration: none;
    color: #fff; /* Metin Rengi */
    font-size: 0.85rem;
    font-weight: 500;
    transition: color 0.3s ease;
    padding: 5px 0;
    /* CSS değişkenlerinin varsayılan değerleri (her öğe için PHP ile geçersiz kılınacak) */
    --icon-bg: #4299e1;
    --icon-fill: #fff;
    --icon-shadow: rgba(66, 153, 225, 0.4);
}

.main-menu a:hover {
    color: #90cdf4; /* Metin Hover Rengi (açık mavi) */
}

/* --- Köşeleri Yuvarlatılmış Kare (Rounded Square) ve Renkli İkon Stili --- */
.main-menu a svg {
    /* İkonların boyutunu ayarlar */
    width: 36px;
    height: 36px;
    /* Köşeleri yuvarlatılmış kare görünümü için */
    padding: 7px;
    border-radius: 10px; /* Yuvarlatılmış köşe miktarı */
    /* Renkleri ve gölgeyi CSS değişkenlerinden alır */
    background-color: var(--icon-bg); /* PHP'den gelen arka plan rengi */
    fill: var(--icon-fill); /* PHP'den gelen ikon dolgu rengi */
    /* Görsel detaylar */
    margin-bottom: 4px;
    box-shadow: 0 4px 8px var(--icon-shadow); /* PHP'den gelen renge uygun gölge */
    transition: all 0.3s ease-in-out;
}

/* İkonun Üzerine Gelme (Hover) Efekti */
.main-menu a:hover svg {
    /* Hover'da arka plan rengini koyulaştırır */
    filter: brightness(0.9);
    box-shadow: 0 6px 12px var(--icon-shadow);
    transform: translateY(-2px); /* Hafif yukarı kayma animasyonu */
}

/* Çıkış Yap butonu özel stil (Daha agresif bir kırmızı) */
.logout-link a svg {
    filter: none; /* Varsayılan parlaklığı koru */
}
.logout-link a:hover svg {
    filter: brightness(0.8); /* Kırmızı hover'da biraz koyulaşsın */
}
</style>

<header>
    <div class="header-branding">
        <a href="dashboard.php" class="header-logo-link">
            <!-- Logonun kendisi burada kalıyor -->
            <img src="img/logo.png" alt="Hati App Logo" class="header-logo">
        </a>
    </div>
    <nav>
        <ul class="main-menu">
            <li>
                <a href="dashboard.php" <?php echo get_icon_style('dashboard.php', $icon_styles); ?>>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 256 256"><path d="M228.69,79.31,136.69,31.31a16,16,0,0,0-17.38,0L27.31,79.31a16,16,0,0,0,0,21.38L120.62,152a16,16,0,0,0,17.38,0l93.31-51.31A16,16,0,0,0,228.69,79.31ZM128,168l-92.68-51.08,8.23-4.52,93.36,51.36a16,16,0,0,0,17.38,0l93.31-51.31,8.23,4.52L128,168Zm101.31-51.31-93.31,51.31a16,16,0,0,1-17.38,0L27.31,116.69a16,16,0,0,0-12,15.28V192a16,16,0,0,0,16,16H224a16,16,0,0,0,16-16V132A16,16,0,0,0,229.31,116.69Z"></path></svg>
                    <span>Anasayfa</span>
                </a>
            </li>
            <li>
                <a href="requests.php" <?php echo get_icon_style('requests.php', $icon_styles); ?>>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 256 256"><path d="M224,88V200a16,16,0,0,1-16,16H48a16,16,0,0,1-16-16V88a16,16,0,0,1,16-16H208A16,16,0,0,1,224,88Zm-16,112V88H48V200ZM80,32a8,8,0,0,0-8,8v16a8,8,0,0,0,16,0V40A8,8,0,0,0,80,32Zm96,0a8,8,0,0,0-8,8v16a8,8,0,0,0,16,0V40A8,8,0,0,0,176,32ZM128,128a8,8,0,0,0-8,8v16a8,8,0,0,0,16,0v-16A8,8,0,0,0,128,128Z"></path></svg>
                    <span>Talepler</span>
                </a>
            </li>
            <li>
                <a href="discoveries.php" <?php echo get_icon_style('discoveries.php', $icon_styles); ?>>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 256 256"><path d="M128,24A104,104,0,1,0,232,128,104.11,104.11,0,0,0,128,24Zm0,192a88,88,0,1,1,88-88A88.1,88.1,0,0,1,128,216Zm41.66-136.34-56,56a8,8,0,0,1-11.32,0l-24-24a8,8,0,0,1,11.32-11.32L112,148.68l50.34-50.34a8,8,0,0,1,11.32,11.32Z"></path></svg>
                    <span>Keşifler</span>
                </a>
            </li>
            <li>
                <a href="offers.php" <?php echo get_icon_style('offers.php', $icon_styles); ?>>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 256 256"><path d="M216.49,88.49l-48-48A2,2,0,0,0,166,40H56A16,16,0,0,0,40,56V200a16,16,0,0,0,16,16H200a16,16,0,0,0,16-16V90A2,2,0,0,0,216.49,88.49ZM176,51.31,196.69,72H176ZM200,200H56V56h96V88a8,8,0,0,0,8,8h32V200ZM152,128v8a8,8,0,0,1-16,0v-8a8,8,0,0,1,16,0Zm-32,32v8a8,8,0,0,1-16,0v-8a8,8,0,0,1,16,0Zm-32,0v8a8,8,0,0,1-16,0v-8a8,8,0,0,1,16,0Z"></path></svg>
                    <span>Teklifler</span>
                </a>
            </li>
            
            <li>
                <a href="projects.php" <?php echo get_icon_style('projects.php', $icon_styles); ?>>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 256 256"><path d="M224,88V200a16,16,0,0,1-16,16H48a16,16,0,0,1-16-16V88a16,16,0,0,1,16-16H208A16,16,0,0,1,224,88Zm-16,112V88H48V200ZM80,32a8,8,0,0,0-8,8v16a8,8,0,0,0,16,0V40A8,8,0,0,0,80,32Zm96,0a8,8,0,0,0-8,8v16a8,8,0,0,0,16,0V40A8,8,0,0,0,176,32ZM128,128a8,8,0,0,0-8,8v16a8,8,0,0,0,16,0v-16A8,8,0,0,0,128,128Z"></path></svg>
                    <span>Projeler</span>
                </a>
            </li>
            <li>
                <a href="stock.php" <?php echo get_icon_style('stock.php', $icon_styles); ?>>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 256 256"><path d="M216,40V216a8,8,0,0,1-16,0V40H56A16,16,0,0,0,40,56V216a16,16,0,0,0,16,16H200a16,16,0,0,0,16-16V56A16,16,0,0,0,200,40H216ZM120,88a8,8,0,0,1-16,0V56h16Zm40,0a8,8,0,0,1-16,0V56h16Z"></path></svg>
                    <span>Stok</span>
                </a>
            </li>
            <li>
                <a href="purchase_requests.php" <?php echo get_icon_style('purchase_requests.php', $icon_styles); ?>>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 256 256"><path d="M216,56V200a16,16,0,0,1-16,16H40a16,16,0,0,1-16-16V56a16,16,0,0,1,16-16H200A16,16,0,0,1,216,56ZM184,120a8,8,0,0,0-8-8H136V88a8,8,0,0,0-16,0v24H80a8,8,0,0,0,0,16h24v24a8,8,0,0,0,16,0V136h24a8,8,0,0,0,8-8Z"></path></svg>
                    <span>Satın Alma</span>
                </a>
            </li>
            <li>
                <a href="quality.php" <?php echo get_icon_style('quality.php', $icon_styles); ?>>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 256 256"><path d="M224,128a8,8,0,0,1-8,8H176v40a8,8,0,0,1-16,0V136H96v40a8,8,0,0,1-16,0V136H40a8,8,0,0,1-8-8,8,8,0,0,1,8-8h32V80a8,8,0,0,1,16,0v40h64V80a8,8,0,0,1,16,0v40h32A8,8,0,0,1,224,128ZM128,40a8,8,0,0,0-8,8V72a8,8,0,0,0,16,0V48A8,8,0,0,0,128,40Z"></path></svg>
                    <span>Kalite</span>
                </a>
            </li>
            <li>
                <a href="personel.php" <?php echo get_icon_style('personel.php', $icon_styles); ?>>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 256 256"><path d="M232,128a104,104,0,1,1-104-104A104.11,104.11,0,0,1,232,128Zm-8,0a96,96,0,1,0-96,96A96.11,96.11,0,0,0,224,128Zm-96,40a8,8,0,0,1-16,0V128a8,8,0,0,1,16,0Zm0-56a12,12,0,1,1-12-12A12,12,0,0,1,128,112Z"></path></svg>
                    <span>Personel</span>
                </a>
            </li>
            <li>
                <a href="araclarimiz.php" <?php echo get_icon_style('araclarimiz.php', $icon_styles); ?>>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 256 256"><path d="M208,32H48A16,16,0,0,0,32,48V208a16,16,0,0,0,16,16H208a16,16,0,0,0,16-16V48A16,16,0,0,0,208,32Zm-8,16a8,8,0,0,1,8,8V200H48V48H200ZM128,144a8,8,0,0,1-8-8V80a8,8,0,0,1,16,0v56A8,8,0,0,1,128,144Zm-40,16a8,8,0,0,1-8-8V80a8,8,0,0,1,16,0v72A8,8,0,0,1,88,160Zm80,0a8,8,0,0,1-8-8V80a8,8,0,0,1,16,0v72A8,8,0,0,1,168,160Z"></path></svg>
                    <span>Araçlar</span>
                </a>
            </li>
            <?php if ($_SESSION['user_role'] === 'admin'): ?>
            <li class="user-menu">
                <a href="muhasebe.php" <?php echo get_icon_style('muhasebe.php', $icon_styles); ?>>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 256 256"><path d="M208,88a64,64,0,1,0-64-64A64.07,64.07,0,0,0,208,88Zm-8,0a56,56,0,1,1-56-56A56.06,56.06,0,0,1,200,88ZM224,216a8,8,0,0,1-8,8H40a8,8,0,0,1-8-8,56,56,0,0,1,56-56h64A56,56,0,0,1,224,216Zm-8,0a48,48,0,0,0-48-48H88a48,48,0,0,0-48,48H216Zm-88-96a8,8,0,0,0,0-16H80a8,8,0,0,0,0,16Z"></path></svg>
                    <span>Muhasebe</span>
                </a>
            </li>
            <?php endif; ?>
            <li class="logout-link">
                <a href="logout.php" <?php echo get_icon_style('logout.php', $icon_styles); ?>>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 256 256"><path d="M128,24A104,104,0,1,0,232,128,104.11,104.11,0,0,0,128,24Zm0,192a88,88,0,1,1,88-88A88.1,88.1,0,0,1,128,216Zm16-88a8,8,0,0,1-8,8H88a8,8,0,0,1,0-16h48A8,8,0,0,1,144,128ZM104,72a8,8,0,0,1,8-8h32a8,8,0,0,1,0,16H112a8,8,0,0,1-8-8Z"></path></svg>
                    <span>Çıkış Yap</span>
                </a>
            </li>
        </ul>
    </nav>
</header>
<main>
