<?php
// src/Includes/helpers.php

function getStatusInfo($status) {
    $translations = [
        'draft' => 'Taslak',
        'sent' => 'Gönderildi',
        'accepted' => 'Kabul Edildi',
        'rejected' => 'Reddedildi',
        'planning' => 'Planlama',
        'in_progress' => 'Devam Ediyor',
        'on_hold' => 'Beklemede',
        'completed' => 'Tamamlandı',
        'cancelled' => 'İptal Edildi',
        'todo' => 'Yapılacak',
        'pending' => 'Onay Bekliyor',
        'waiting_approval' => 'Onay Bekliyor',
        'approved' => 'Onaylandı',
        'ordered' => 'Sipariş Edildi',
        'invoiced' => 'Faturalandırıldı',
        'paid' => 'Ödendi',
        'partially_paid' => 'Kısmen Ödendi',
        'waiting' => 'Beklemede',
        'new' => 'Yeni',
        'pending_plan' => 'Planlama Bekliyor',
        'completed_successful' => 'Tamamlandı (Teklif Oluşturuldu)',
        'completed_unsuccessful' => 'Tamamlanamadı'
    ];
    $turkish_status = $translations[$status] ?? $status;
    $css_class = 'status-' . str_replace(['_'], ['-'], $status);
    return ['label' => $turkish_status, 'class' => $css_class];
}